/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.persistence.payload;

import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.persistence.payload.BucketLock;
import com.hivemq.persistence.payload.PayloadReferenceCounterRegistry;
import com.hivemq.persistence.payload.PublishPayloadLocalPersistence;
import com.hivemq.persistence.payload.RemovablePayloads;
import com.hivemq.util.Exceptions;
import java.util.Queue;

class RemoveEntryTask
implements Runnable {
    @NotNull
    private final PublishPayloadLocalPersistence localPersistence;
    @NotNull
    private final BucketLock bucketLock;
    @NotNull
    private final @NotNull RemovablePayloads @NotNull [] responsibleBuckets;
    @NotNull
    private final PayloadReferenceCounterRegistry payloadReferenceCounterRegistry;

    RemoveEntryTask(@NotNull BucketLock bucketLock, @NotNull PayloadReferenceCounterRegistry payloadReferenceCounterRegistry, @NotNull PublishPayloadLocalPersistence localPersistence, @NotNull @NotNull RemovablePayloads @NotNull [] responsibleBuckets) {
        this.localPersistence = localPersistence;
        this.bucketLock = bucketLock;
        this.responsibleBuckets = responsibleBuckets;
        this.payloadReferenceCounterRegistry = payloadReferenceCounterRegistry;
    }

    @Override
    public void run() {
        try {
            for (RemovablePayloads responsibleBucket : this.responsibleBuckets) {
                if (responsibleBucket.getQueue().isEmpty()) continue;
                this.bucketLock.accessBucket(responsibleBucket.getBucketIndex(), index -> this.cleanupQueueCompletely(responsibleBucket));
            }
        }
        catch (Throwable t) {
            Exceptions.rethrowError("Exception during payload cleanup. ", t);
        }
    }

    private void cleanupQueueCompletely(@NotNull RemovablePayloads removablePayloads) {
        Long payloadId;
        Queue<Long> removablePayloadQueue = removablePayloads.getQueue();
        while ((payloadId = removablePayloadQueue.poll()) != null) {
            int referenceCount = this.payloadReferenceCounterRegistry.get(payloadId);
            if (referenceCount != 0) continue;
            this.localPersistence.remove(payloadId);
            this.payloadReferenceCounterRegistry.delete(payloadId);
        }
    }
}

