/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.security.ssl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.hash.Funnel;
import com.google.common.hash.Funnels;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import com.google.common.hash.PrimitiveSink;
import com.google.inject.Inject;
import com.hivemq.bootstrap.ioc.lazysingleton.LazySingleton;
import com.hivemq.configuration.service.entity.Tls;
import com.hivemq.exceptions.UnrecoverableException;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.security.exception.SslException;
import com.hivemq.security.ioc.Security;
import com.hivemq.security.ssl.SslContextFactory;
import io.netty.handler.ssl.SslContext;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LazySingleton
public class SslContextStore {
    @NotNull
    private static final Logger log = LoggerFactory.getLogger(SslContextStore.class);
    @NotNull
    private final ScheduledExecutorService executorService;
    @NotNull
    private final SslContextFactory sslContextFactory;
    @NotNull
    private final ConcurrentMap<Tls, SslContext> sslContextMap;
    @NotNull
    private final ConcurrentMap<Tls, HashCode> checksumMap;

    @Inject
    public SslContextStore(@Security @NotNull ScheduledExecutorService executorService, @NotNull SslContextFactory sslContextFactory) {
        this.executorService = executorService;
        this.sslContextFactory = sslContextFactory;
        this.sslContextMap = new ConcurrentHashMap<Tls, SslContext>();
        this.checksumMap = new ConcurrentHashMap<Tls, HashCode>();
    }

    @NotNull
    public SslContext getAndInitAsync(@NotNull Tls tls) {
        return this.getAndInit(tls, this.executorService, sslContext -> {});
    }

    public void createAndInitIfAbsent(@NotNull Tls tls, @NotNull Consumer<SslContext> onCreate) {
        this.getAndInit(tls, Runnable::run, onCreate);
    }

    @NotNull
    private SslContext getAndInit(@NotNull Tls tls, @NotNull Executor initExecutor, @NotNull Consumer<SslContext> onCreate) {
        return this.sslContextMap.computeIfAbsent(tls, key -> {
            SslContext sslContext = this.sslContextFactory.createSslContext((Tls)key);
            initExecutor.execute(new SslContextFirstTimeRunnable((Tls)key));
            onCreate.accept(sslContext);
            return sslContext;
        });
    }

    @VisibleForTesting
    @NotNull
    static HashCode hashKeystoreAndTruststore(@NotNull Tls tls) throws IOException {
        try {
            return Hashing.md5().hashObject((Object)tls, (Funnel)KeystoreAndTruststoreHashFunnel.INSTANCE);
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    private static enum KeystoreAndTruststoreHashFunnel implements Funnel<Tls>
    {
        INSTANCE;


        public void funnel(@NotNull Tls tls, @NotNull PrimitiveSink sink) {
            KeystoreAndTruststoreHashFunnel.funnelFile(tls.getKeystorePath(), sink);
            if (StringUtils.isNotBlank((CharSequence)tls.getTruststorePath())) {
                KeystoreAndTruststoreHashFunnel.funnelFile(tls.getTruststorePath(), sink);
            }
        }

        private static void funnelFile(@NotNull String fileName, @NotNull PrimitiveSink sink) {
            try (FileInputStream fileInputStream = new FileInputStream(fileName);){
                fileInputStream.transferTo(Funnels.asOutputStream((PrimitiveSink)sink));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    @VisibleForTesting
    final class SslContextScheduledRunnable
    implements Runnable {
        @NotNull
        private final Tls tls;

        private SslContextScheduledRunnable(Tls tls) {
            this.tls = tls;
        }

        @Override
        public void run() {
            try {
                HashCode hash = SslContextStore.hashKeystoreAndTruststore(this.tls);
                HashCode oldHash = (HashCode)SslContextStore.this.checksumMap.get(this.tls);
                if (!hash.equals((Object)oldHash)) {
                    SslContext context = SslContextStore.this.sslContextFactory.createSslContext(this.tls);
                    SslContextStore.this.sslContextMap.put(this.tls, context);
                    SslContextStore.this.checksumMap.put(this.tls, hash);
                    log.info("Successfully updated changed SSL Context");
                }
            }
            catch (FileNotFoundException e) {
                log.warn("Could not find keystore or truststore file", (Throwable)e);
            }
            catch (SslException e) {
                log.warn("Could not parse new SSL Context from changed keystore or truststore", (Throwable)e);
            }
            catch (Exception e) {
                log.warn("Scheduled SSL Context check failed", (Throwable)e);
            }
        }
    }

    @VisibleForTesting
    final class SslContextFirstTimeRunnable
    implements Runnable {
        @NotNull
        private final Tls tls;

        private SslContextFirstTimeRunnable(Tls tls) {
            this.tls = tls;
        }

        @Override
        public void run() {
            try {
                HashCode hash = SslContextStore.hashKeystoreAndTruststore(this.tls);
                SslContextStore.this.checksumMap.put(this.tls, hash);
            }
            catch (Exception e) {
                log.error("Could not generate initial hash of KeyStore and TrustStore", (Throwable)e);
                throw new UnrecoverableException();
            }
            SslContextStore.this.executorService.scheduleAtFixedRate(new SslContextScheduledRunnable(this.tls), 10L, 10L, TimeUnit.SECONDS);
        }
    }
}

