/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.statistics;

import com.hivemq.configuration.info.SystemInformation;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class HivemqId {
    private static final Logger log = LoggerFactory.getLogger(HivemqId.class);
    private final SystemInformation systemInformation;
    private String hivemqId;

    @Inject
    public HivemqId(SystemInformation systemInformation) {
        this.systemInformation = systemInformation;
    }

    @PostConstruct
    void postConstruct() {
        this.readId();
    }

    private void readId() {
        File file = new File(this.systemInformation.getDataFolder(), "meta.id");
        if (!file.exists()) {
            try {
                FileUtils.writeStringToFile((File)file, (String)this.getHivemqId(), (Charset)StandardCharsets.UTF_8);
                return;
            }
            catch (IOException e) {
                log.debug("Not able to write installation ID to file {}", (Object)file.getAbsolutePath());
                log.trace("original exception");
            }
        }
        if (file.canRead()) {
            try {
                String hivemqId = FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
                if (hivemqId.length() != 36) {
                    return;
                }
                this.hivemqId = hivemqId;
            }
            catch (IOException e) {
                log.debug("Not able to read installation ID from file {}", (Object)file.getAbsolutePath());
                log.trace("original exception");
            }
        }
    }

    public String getHivemqId() {
        if (this.hivemqId == null) {
            this.hivemqId = UUID.randomUUID().toString();
        }
        return this.hivemqId;
    }
}

