/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.util;

import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.hivemq.bootstrap.ioc.lazysingleton.LazySingleton;
import com.hivemq.configuration.HivemqId;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicLong;
import javax.inject.Inject;

@LazySingleton
public class ClientIds {
    private final AtomicLong clientIDCounter = new AtomicLong(0L);
    private final String hivemqId;
    private final HashFunction hashFunction = Hashing.murmur3_128();

    @Inject
    public ClientIds(HivemqId hiveMQId) {
        this.hivemqId = hiveMQId.get();
    }

    public String generateNext() {
        long currentCounter = this.clientIDCounter.getAndIncrement();
        String rawID = "hmq_" + this.hivemqId + "_" + currentCounter + "_" + System.currentTimeMillis();
        return "hmq_" + this.hivemqId + "_" + currentCounter + "_" + this.hashFunction.hashString((CharSequence)rawID, StandardCharsets.UTF_8).toString();
    }
}

