/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.apimachinery;

import com.google.common.base.Strings;
import io.kubernetes.client.apimachinery.KubernetesResource;
import io.kubernetes.client.apimachinery.KubernetesVerb;
import io.kubernetes.client.apimachinery.ParseKubernetesResourceException;
import java.util.regex.Pattern;
import okhttp3.Request;

public class KubernetesRequestDigest {
    public static final Pattern RESOURCE_URL_PATH_PATTERN = Pattern.compile("^/(api|apis)(/\\S+)?/v\\d\\w*/\\S+");
    private final String urlPath;
    private final boolean isNonResourceRequest;
    private final KubernetesResource resourceMeta;
    private final KubernetesVerb verb;

    KubernetesRequestDigest(String urlPath, boolean isNonResourceRequest, KubernetesResource resourceMeta, KubernetesVerb verb) {
        this.urlPath = urlPath;
        this.isNonResourceRequest = isNonResourceRequest;
        this.resourceMeta = resourceMeta;
        this.verb = verb;
    }

    public static KubernetesRequestDigest parse(Request request) {
        String urlPath = request.url().encodedPath();
        if (!KubernetesRequestDigest.isResourceRequest(urlPath)) {
            return KubernetesRequestDigest.nonResource(urlPath);
        }
        try {
            KubernetesResource resourceMeta = urlPath.startsWith("/api/v1") ? KubernetesResource.parseCoreResource(urlPath) : KubernetesResource.parseRegularResource(urlPath);
            return new KubernetesRequestDigest(urlPath, false, resourceMeta, KubernetesVerb.of(request.method(), KubernetesRequestDigest.hasNamePathParameter(resourceMeta), KubernetesRequestDigest.hasWatchParameter(request)));
        }
        catch (ParseKubernetesResourceException e) {
            return KubernetesRequestDigest.nonResource(urlPath);
        }
    }

    private static KubernetesRequestDigest nonResource(String urlPath) {
        KubernetesRequestDigest digest = new KubernetesRequestDigest(urlPath, true, null, null);
        return digest;
    }

    public static boolean isResourceRequest(String urlPath) {
        return RESOURCE_URL_PATH_PATTERN.matcher(urlPath).matches();
    }

    private static boolean hasWatchParameter(Request request) {
        return !Strings.isNullOrEmpty((String)request.url().queryParameter("watch"));
    }

    private static boolean hasNamePathParameter(KubernetesResource resource) {
        return !Strings.isNullOrEmpty((String)resource.getName());
    }

    public String getUrlPath() {
        return this.urlPath;
    }

    public boolean isNonResourceRequest() {
        return this.isNonResourceRequest;
    }

    public KubernetesResource getResourceMeta() {
        return this.resourceMeta;
    }

    public KubernetesVerb getVerb() {
        return this.verb;
    }

    public String toString() {
        if (this.isNonResourceRequest) {
            return (Object)((Object)this.verb) + ' ' + this.urlPath;
        }
        String groupVersion = Strings.isNullOrEmpty((String)this.resourceMeta.getGroupVersionResource().getGroup()) ? "" : this.resourceMeta.getGroupVersionResource().getGroup() + "/" + this.resourceMeta.getGroupVersionResource().getVersion();
        String targetResourceName = Strings.isNullOrEmpty((String)this.resourceMeta.getSubResource()) ? this.resourceMeta.getGroupVersionResource().getResource() : this.resourceMeta.getGroupVersionResource().getResource() + "/" + this.resourceMeta.getSubResource();
        return this.verb.value() + ' ' + groupVersion + ' ' + targetResourceName;
    }
}

