/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.util;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.ClassPath;
import com.google.common.util.concurrent.Striped;
import io.kubernetes.client.Discovery;
import io.kubernetes.client.apimachinery.GroupVersionKind;
import io.kubernetes.client.apimachinery.GroupVersionResource;
import io.kubernetes.client.common.KubernetesListObject;
import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.util.Yaml;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelMapper {
    private static final Logger logger = LoggerFactory.getLogger(ModelMapper.class);
    public static final Duration DEFAULT_DISCOVERY_REFRESH_INTERVAL = Duration.ofMinutes(30L);
    private static Map<GroupVersionKind, Class<?>> preBuiltClassesByGVK = new HashMap();
    private static Map<String, String> preBuiltApiGroups = new HashMap<String, String>();
    private static List<String> preBuiltApiVersions = new ArrayList<String>();
    private static BiDirectionalMap<GroupVersionKind, Class<?>> classesByGVK = new BiDirectionalMap();
    private static BiDirectionalMap<GroupVersionResource, Class<?>> classesByGVR = new BiDirectionalMap();
    private static Map<Class<?>, Boolean> isNamespacedByClasses = new ConcurrentHashMap();
    private static Set<Discovery.APIResource> lastAPIDiscovery = new HashSet<Discovery.APIResource>();
    private static volatile long nextDiscoveryRefreshTimeMillis = 0L;

    @Deprecated
    public static void addModelMap(String apiGroupVersion, String kind, Class<?> clazz) {
        String[] parts = apiGroupVersion.split("/");
        if (parts.length == 1) {
            ModelMapper.addModelMap("", apiGroupVersion, kind, clazz);
        }
        ModelMapper.addModelMap(parts[0], parts[1], kind, clazz);
    }

    @Deprecated
    public static void addModelMap(String group, String version, String kind, Class<?> clazz) {
        ModelMapper.preBuiltAddModelMap(group, version, kind, clazz);
    }

    public static void addModelMap(String group, String version, String kind, String resourceNamePlural, Class<?> clazz) {
        classesByGVK.add(new GroupVersionKind(group, version, kind), clazz);
        classesByGVR.add(new GroupVersionResource(group, version, resourceNamePlural), clazz);
    }

    public static void addModelMap(String group, String version, String kind, String resourceNamePlural, Boolean isNamespacedResource, Class<?> clazz) {
        ModelMapper.addModelMap(group, version, kind, resourceNamePlural, clazz);
        isNamespacedByClasses.put(clazz, isNamespacedResource);
    }

    public static Class<?> getApiTypeClass(String apiGroupVersion, String kind) {
        String apiVersion;
        String apiGroup;
        String[] parts = apiGroupVersion.split("/");
        if (parts.length == 1) {
            apiGroup = "";
            apiVersion = apiGroupVersion;
        } else {
            apiGroup = parts[0];
            apiVersion = parts[1];
        }
        return ModelMapper.getApiTypeClass(apiGroup, apiVersion, kind);
    }

    public static Class<?> getApiTypeClass(String group, String version, String kind) {
        Class<?> clazz = classesByGVK.getByK(new GroupVersionKind(group, version, kind));
        if (clazz != null) {
            return clazz;
        }
        return ModelMapper.preBuiltGetApiTypeClass(group, version, kind);
    }

    public static GroupVersionKind getGroupVersionKindByClass(Class<?> clazz) {
        return classesByGVK.getByV(clazz);
    }

    public static GroupVersionResource getGroupVersionResourceByClass(Class<?> clazz) {
        return classesByGVR.getByV(clazz);
    }

    public static Set<Discovery.APIResource> refresh(Discovery discovery) throws ApiException {
        return ModelMapper.refresh(discovery, DEFAULT_DISCOVERY_REFRESH_INTERVAL);
    }

    public static Set<Discovery.APIResource> refresh(Discovery discovery, Duration refreshInterval) throws ApiException {
        long nowMillis = System.currentTimeMillis();
        if (nowMillis < nextDiscoveryRefreshTimeMillis) {
            return lastAPIDiscovery;
        }
        Set<Discovery.APIResource> apiResources = discovery.findAll();
        for (Discovery.APIResource apiResource : apiResources) {
            for (String version : apiResource.getVersions()) {
                Class<?> clazz = ModelMapper.getApiTypeClass(apiResource.getGroup(), version, apiResource.getKind());
                if (clazz == null) continue;
                ModelMapper.addModelMap(apiResource.getGroup(), version, apiResource.getKind(), apiResource.getResourcePlural(), apiResource.getNamespaced(), clazz);
            }
        }
        lastAPIDiscovery = apiResources;
        nextDiscoveryRefreshTimeMillis = refreshInterval.toMillis() + nowMillis;
        return lastAPIDiscovery;
    }

    public static boolean isApiDiscoveryRefreshed() {
        return nextDiscoveryRefreshTimeMillis != 0L;
    }

    static void preBuiltAddModelMap(String group, String version, String kind, Class<?> clazz) {
        preBuiltClassesByGVK.put(new GroupVersionKind(group, version, kind), clazz);
    }

    public static Class<?> preBuiltGetApiTypeClass(String group, String version, String kind) {
        Class<?> clazz = preBuiltClassesByGVK.get(new GroupVersionKind(group, version, kind));
        if (clazz != null) {
            return clazz;
        }
        return preBuiltClassesByGVK.get(new GroupVersionKind("", version, kind));
    }

    public static GroupVersionKind preBuiltGetGroupVersionKindByClass(Class<?> clazz) {
        return preBuiltClassesByGVK.entrySet().stream().filter(e -> clazz.equals(e.getValue())).map(e -> (GroupVersionKind)e.getKey()).findFirst().get();
    }

    public static Boolean isNamespaced(Class<?> clazz) {
        return isNamespacedByClasses.get(clazz);
    }

    private static void initApiGroupMap() {
        preBuiltApiGroups.put("Admissionregistration", "admissionregistration.k8s.io");
        preBuiltApiGroups.put("Apiextensions", "apiextensions.k8s.io");
        preBuiltApiGroups.put("Apiregistration", "apiregistration.k8s.io");
        preBuiltApiGroups.put("Apps", "apps");
        preBuiltApiGroups.put("Authentication", "authentication.k8s.io");
        preBuiltApiGroups.put("Authorization", "authorization.k8s.io");
        preBuiltApiGroups.put("Autoscaling", "autoscaling");
        preBuiltApiGroups.put("Extensions", "extensions");
        preBuiltApiGroups.put("Batch", "batch");
        preBuiltApiGroups.put("Certificates", "certificates.k8s.io");
        preBuiltApiGroups.put("Networking", "networking.k8s.io");
        preBuiltApiGroups.put("Policy", "policy");
        preBuiltApiGroups.put("RbacAuthorization", "rbac.authorization.k8s.io");
        preBuiltApiGroups.put("Scheduling", "scheduling.k8s.io");
        preBuiltApiGroups.put("Settings", "settings.k8s.io");
        preBuiltApiGroups.put("Storage", "storage.k8s.io");
        preBuiltApiGroups.put("FlowControl", "flowcontrol.apiserver.k8s.io");
    }

    private static void initApiVersionList() {
        preBuiltApiVersions.add("V2beta1");
        preBuiltApiVersions.add("V2beta2");
        preBuiltApiVersions.add("V2alpha1");
        preBuiltApiVersions.add("V1beta2");
        preBuiltApiVersions.add("V1beta1");
        preBuiltApiVersions.add("V1alpha1");
        preBuiltApiVersions.add("V1");
    }

    private static void initModelMap() throws IOException {
        ModelMapper.initApiGroupMap();
        ModelMapper.initApiVersionList();
        ClassPath cp = ClassPath.from((ClassLoader)Yaml.class.getClassLoader());
        ImmutableSet allClasses = cp.getTopLevelClasses("io.kubernetes.client.openapi.models");
        for (ClassPath.ClassInfo classInfo : allClasses) {
            Class clazz = classInfo.load();
            if (!KubernetesObject.class.isAssignableFrom(clazz) && !KubernetesListObject.class.isAssignableFrom(clazz)) continue;
            Pair<String, String> groupAndOther = ModelMapper.getApiGroup(clazz.getSimpleName());
            Pair<String, String> versionAndOther = ModelMapper.getApiVersion((String)groupAndOther.getRight());
            String group = Strings.nullToEmpty((String)((String)groupAndOther.getLeft()));
            String version = (String)versionAndOther.getLeft();
            String kind = (String)versionAndOther.getRight();
            preBuiltClassesByGVK.put(new GroupVersionKind(group, version, kind), clazz);
        }
    }

    private static Pair<String, String> getApiGroup(String name) {
        return (Pair)preBuiltApiGroups.entrySet().stream().filter(e -> name.startsWith((String)e.getKey())).map(e -> new MutablePair(e.getValue(), (Object)name.substring(((String)e.getKey()).length()))).findFirst().orElse(new MutablePair(null, (Object)name));
    }

    private static Pair<String, String> getApiVersion(String name) {
        return (Pair)preBuiltApiVersions.stream().filter(v -> name.startsWith((String)v)).map(v -> new MutablePair((Object)v.toLowerCase(), (Object)name.substring(v.length()))).findFirst().orElse(new MutablePair(null, (Object)name));
    }

    static {
        try {
            ModelMapper.initModelMap();
        }
        catch (Exception ex) {
            logger.error("Unexpected exception while loading classes: " + ex);
        }
    }

    static class BiDirectionalMap<K, V> {
        private Map<K, V> kvMap = new HashMap();
        private Map<V, K> vkMap = new HashMap<V, K>();
        private Striped<ReadWriteLock> lock = Striped.readWriteLock((int)(Runtime.getRuntime().availableProcessors() * 4));

        BiDirectionalMap() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void add(K k, V v) {
            ReadWriteLock keyLock = (ReadWriteLock)this.lock.get(k);
            ReadWriteLock valueLock = (ReadWriteLock)this.lock.get(v);
            keyLock.writeLock().lock();
            valueLock.writeLock().lock();
            try {
                this.kvMap.put(k, v);
                this.vkMap.put(v, k);
            }
            finally {
                keyLock.writeLock().unlock();
                valueLock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V getByK(K k) {
            ReadWriteLock l = (ReadWriteLock)this.lock.get(k);
            l.readLock().lock();
            try {
                V v = this.kvMap.get(k);
                return v;
            }
            finally {
                l.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        K getByV(V v) {
            ReadWriteLock l = (ReadWriteLock)this.lock.get(v);
            l.readLock().lock();
            try {
                K k = this.vkMap.get(v);
                return k;
            }
            finally {
                l.readLock().unlock();
            }
        }
    }
}

