/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.components.device;

import org.eclipse.basyx.components.device.BaseDevice;
import org.eclipse.basyx.components.device.IBaSysNativeDeviceStatus;
import org.eclipse.basyx.components.netcomm.TCPClient;

public abstract class BaseTCPDeviceAdapter
extends BaseDevice
implements IBaSysNativeDeviceStatus {
    protected TCPClient communicationClient = null;
    protected int serverPort;

    public BaseTCPDeviceAdapter(int port) {
        this.serverPort = port;
    }

    @Override
    protected void onServiceInvocation() {
        super.onServiceInvocation();
        this.communicationClient.sendMessage("invocation:start\n");
    }

    @Override
    protected void onServiceEnd() {
        super.onServiceEnd();
        this.communicationClient.sendMessage("invocation:end\n");
    }

    @Override
    protected void statusChange(String newStatus) {
        this.communicationClient.sendMessage("status:" + newStatus + "\n");
    }

    public void closeSocket() {
        this.communicationClient.close();
    }

    @Override
    public void start() {
        super.start();
        this.communicationClient = new TCPClient("localhost", this.serverPort);
    }

    @Override
    public void stop() {
        super.stop();
        this.closeSocket();
    }

    @Override
    public void waitFor() {
    }
}

