/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.qpid.server.model.AccessControlProvider;
import org.apache.qpid.server.model.AuthenticationProvider;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.BrokerConnectionLimitProvider;
import org.apache.qpid.server.model.BrokerLogInclusionRule;
import org.apache.qpid.server.model.BrokerLogger;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.ConfiguredObjectFactory;
import org.apache.qpid.server.model.ConfiguredObjectFactoryImpl;
import org.apache.qpid.server.model.ConfiguredObjectTypeRegistry;
import org.apache.qpid.server.model.Connection;
import org.apache.qpid.server.model.Consumer;
import org.apache.qpid.server.model.Exchange;
import org.apache.qpid.server.model.Group;
import org.apache.qpid.server.model.GroupMember;
import org.apache.qpid.server.model.GroupProvider;
import org.apache.qpid.server.model.KeyStore;
import org.apache.qpid.server.model.Model;
import org.apache.qpid.server.model.Plugin;
import org.apache.qpid.server.model.Port;
import org.apache.qpid.server.model.Producer;
import org.apache.qpid.server.model.Queue;
import org.apache.qpid.server.model.RemoteReplicationNode;
import org.apache.qpid.server.model.Session;
import org.apache.qpid.server.model.SystemConfig;
import org.apache.qpid.server.model.TrustStore;
import org.apache.qpid.server.model.User;
import org.apache.qpid.server.model.VirtualHost;
import org.apache.qpid.server.model.VirtualHostAccessControlProvider;
import org.apache.qpid.server.model.VirtualHostAlias;
import org.apache.qpid.server.model.VirtualHostConnectionLimitProvider;
import org.apache.qpid.server.model.VirtualHostLogInclusionRule;
import org.apache.qpid.server.model.VirtualHostLogger;
import org.apache.qpid.server.model.VirtualHostNode;
import org.apache.qpid.server.plugin.ConfiguredObjectAttributeInjector;
import org.apache.qpid.server.plugin.ConfiguredObjectRegistration;
import org.apache.qpid.server.plugin.QpidServiceLoader;

public final class BrokerModel
extends Model {
    public static final int MODEL_MAJOR_VERSION = 9;
    public static final int MODEL_MINOR_VERSION = 0;
    public static final String MODEL_VERSION = "9.0";
    private static final Model MODEL_INSTANCE = new BrokerModel();
    private final Map<Class<? extends ConfiguredObject>, Class<? extends ConfiguredObject>> _parents = new HashMap<Class<? extends ConfiguredObject>, Class<? extends ConfiguredObject>>();
    private final Map<Class<? extends ConfiguredObject>, Collection<Class<? extends ConfiguredObject>>> _children = new HashMap<Class<? extends ConfiguredObject>, Collection<Class<? extends ConfiguredObject>>>();
    private final Set<Class<? extends ConfiguredObject>> _supportedTypes = new HashSet<Class<? extends ConfiguredObject>>();
    private final ConfiguredObjectTypeRegistry _typeRegistry;
    private Class<? extends ConfiguredObject> _rootCategory;
    private final ConfiguredObjectFactory _objectFactory;

    private BrokerModel() {
        this.setRootCategory(SystemConfig.class);
        this.addRelationship(SystemConfig.class, Broker.class);
        this.addRelationship(Broker.class, BrokerLogger.class);
        this.addRelationship(Broker.class, VirtualHostNode.class);
        this.addRelationship(Broker.class, TrustStore.class);
        this.addRelationship(Broker.class, KeyStore.class);
        this.addRelationship(Broker.class, Port.class);
        this.addRelationship(Broker.class, AccessControlProvider.class);
        this.addRelationship(Broker.class, AuthenticationProvider.class);
        this.addRelationship(Broker.class, GroupProvider.class);
        this.addRelationship(Broker.class, Plugin.class);
        this.addRelationship(Broker.class, BrokerConnectionLimitProvider.class);
        this.addRelationship(BrokerLogger.class, BrokerLogInclusionRule.class);
        this.addRelationship(VirtualHostNode.class, VirtualHost.class);
        this.addRelationship(VirtualHostNode.class, RemoteReplicationNode.class);
        this.addRelationship(VirtualHost.class, VirtualHostLogger.class);
        this.addRelationship(VirtualHost.class, VirtualHostAccessControlProvider.class);
        this.addRelationship(VirtualHost.class, Exchange.class);
        this.addRelationship(VirtualHost.class, Queue.class);
        this.addRelationship(VirtualHost.class, VirtualHostConnectionLimitProvider.class);
        this.addRelationship(VirtualHostLogger.class, VirtualHostLogInclusionRule.class);
        this.addRelationship(Port.class, VirtualHostAlias.class);
        this.addRelationship(Port.class, Connection.class);
        this.addRelationship(AuthenticationProvider.class, User.class);
        this.addRelationship(GroupProvider.class, Group.class);
        this.addRelationship(Group.class, GroupMember.class);
        this.addRelationship(Connection.class, Session.class);
        this.addRelationship(Session.class, Producer.class);
        this.addRelationship(Queue.class, Consumer.class);
        this._objectFactory = new ConfiguredObjectFactoryImpl(this);
        this._typeRegistry = new ConfiguredObjectTypeRegistry(new QpidServiceLoader().instancesOf(ConfiguredObjectRegistration.class), new QpidServiceLoader().instancesOf(ConfiguredObjectAttributeInjector.class), this.getSupportedCategories(), this._objectFactory);
    }

    @Override
    public final ConfiguredObjectTypeRegistry getTypeRegistry() {
        return this._typeRegistry;
    }

    public static Model getInstance() {
        return MODEL_INSTANCE;
    }

    @Override
    public Class<? extends ConfiguredObject> getRootCategory() {
        return this._rootCategory;
    }

    @Override
    public Class<? extends ConfiguredObject> getParentType(Class<? extends ConfiguredObject> child) {
        return this._parents.get(child);
    }

    @Override
    public int getMajorVersion() {
        return 9;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public ConfiguredObjectFactory getObjectFactory() {
        return this._objectFactory;
    }

    @Override
    public Collection<Class<? extends ConfiguredObject>> getChildTypes(Class<? extends ConfiguredObject> parent) {
        Collection<Class<? extends ConfiguredObject>> childTypes = this._children.get(parent);
        return childTypes == null ? Collections.emptyList() : Collections.unmodifiableCollection(childTypes);
    }

    @Override
    public Collection<Class<? extends ConfiguredObject>> getSupportedCategories() {
        return Collections.unmodifiableSet(this._supportedTypes);
    }

    public void setRootCategory(Class<? extends ConfiguredObject> rootCategory) {
        this._rootCategory = rootCategory;
    }

    private void addRelationship(Class<? extends ConfiguredObject> parent, Class<? extends ConfiguredObject> child) {
        if (this._parents.containsKey(child)) {
            throw new IllegalArgumentException("Child class " + child.getSimpleName() + " already has parent " + this._parents.get(child).getSimpleName());
        }
        this._parents.put(child, parent);
        Collection<Class<? extends ConfiguredObject>> children = this._children.get(parent);
        if (children == null) {
            children = new ArrayList<Class<? extends ConfiguredObject>>();
            this._children.put(parent, children);
        }
        children.add(child);
        this._supportedTypes.add(parent);
        this._supportedTypes.add(child);
    }
}

