/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.queue;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.model.Queue;
import org.apache.qpid.server.queue.AbstractQueueEntryList;
import org.apache.qpid.server.queue.OrderedQueueEntry;
import org.apache.qpid.server.queue.QueueEntry;
import org.apache.qpid.server.queue.QueueEntryIterator;
import org.apache.qpid.server.queue.QueueEntryList;
import org.apache.qpid.server.queue.QueueStatistics;
import org.apache.qpid.server.store.MessageEnqueueRecord;

public abstract class OrderedQueueEntryList
extends AbstractQueueEntryList {
    private final OrderedQueueEntry _head;
    private volatile OrderedQueueEntry _tail;
    static final AtomicReferenceFieldUpdater<OrderedQueueEntryList, OrderedQueueEntry> _tailUpdater = AtomicReferenceFieldUpdater.newUpdater(OrderedQueueEntryList.class, OrderedQueueEntry.class, "_tail");
    private final Queue<?> _queue;
    static final AtomicReferenceFieldUpdater<OrderedQueueEntry, OrderedQueueEntry> _nextUpdater = OrderedQueueEntry._nextUpdater;
    private final AtomicLong _scavenges = new AtomicLong(0L);
    private final long _scavengeCount;
    private final AtomicReference<QueueEntry> _unscavengedHWM = new AtomicReference();

    public OrderedQueueEntryList(Queue<?> queue, QueueStatistics queueStatistics, HeadCreator headCreator) {
        super(queue, queueStatistics);
        this._queue = queue;
        this._scavengeCount = this._queue.getContextValue(Integer.class, "qpid.queue.scavenge_count").intValue();
        this._tail = this._head = headCreator.createHead(this);
    }

    void scavenge() {
        QueueEntry hwm = this._unscavengedHWM.getAndSet(null);
        if (hwm != null) {
            for (QueueEntry next = this._head.getNextValidEntry(); next != null && hwm.compareTo(next) > 0; next = next.getNextValidEntry()) {
            }
        }
    }

    @Override
    public Queue<?> getQueue() {
        return this._queue;
    }

    @Override
    public QueueEntry add(ServerMessage message, MessageEnqueueRecord enqueueRecord) {
        OrderedQueueEntry node = this.createQueueEntry(message, enqueueRecord);
        this.updateStatsOnEnqueue(node);
        while (true) {
            OrderedQueueEntry tail = this._tail;
            OrderedQueueEntry next = tail.getNextNode();
            if (tail != this._tail) continue;
            if (next == null) {
                node.setEntryId(tail.getEntryId() + 1L);
                if (!_nextUpdater.compareAndSet(tail, null, node)) continue;
                _tailUpdater.compareAndSet(this, tail, node);
                return node;
            }
            _tailUpdater.compareAndSet(this, tail, next);
        }
    }

    protected abstract OrderedQueueEntry createQueueEntry(ServerMessage<?> var1, MessageEnqueueRecord var2);

    @Override
    public QueueEntry next(QueueEntry node) {
        return node.getNextValidEntry();
    }

    @Override
    public QueueEntryIterator iterator() {
        return new QueueEntryIteratorImpl(this._head);
    }

    @Override
    public QueueEntry getHead() {
        return this._head;
    }

    @Override
    public QueueEntry getTail() {
        return this._tail;
    }

    @Override
    public void entryDeleted(QueueEntry queueEntry) {
        OrderedQueueEntry newNext;
        OrderedQueueEntry next = this._head.getNextNode();
        if (next == (newNext = this._head.getNextValidEntry())) {
            QueueEntry unscavengedHWM = this._unscavengedHWM.get();
            while (unscavengedHWM == null || unscavengedHWM.compareTo(queueEntry) < 0) {
                this._unscavengedHWM.compareAndSet(unscavengedHWM, queueEntry);
                unscavengedHWM = this._unscavengedHWM.get();
            }
            if (this._scavenges.incrementAndGet() > this._scavengeCount) {
                this._scavenges.set(0L);
                this.scavenge();
            }
        } else {
            QueueEntry unscavengedHWM = this._unscavengedHWM.get();
            if (unscavengedHWM != null && (next == null || unscavengedHWM.compareTo(next) < 0)) {
                this._unscavengedHWM.compareAndSet(unscavengedHWM, null);
            }
        }
    }

    @Override
    public int getPriorities() {
        return 0;
    }

    @Override
    public QueueEntry getOldestEntry() {
        return this.next(this.getHead());
    }

    public static class QueueEntryIteratorImpl
    implements QueueEntryIterator {
        private QueueEntry _lastNode;

        QueueEntryIteratorImpl(QueueEntry startNode) {
            this._lastNode = startNode;
        }

        @Override
        public boolean atTail() {
            return this._lastNode.getNextValidEntry() == null;
        }

        @Override
        public QueueEntry getNode() {
            return this._lastNode;
        }

        @Override
        public boolean advance() {
            QueueEntry nextValidNode = this._lastNode.getNextValidEntry();
            if (nextValidNode != null) {
                this._lastNode = nextValidNode;
            }
            return nextValidNode != null;
        }
    }

    public static interface HeadCreator {
        public OrderedQueueEntry createHead(QueueEntryList var1);
    }
}

