/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.stats;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;
import javax.security.auth.Subject;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.ConfiguredObjectOperation;
import org.apache.qpid.server.model.ConfiguredObjectTypeRegistry;
import org.apache.qpid.server.model.ManagedObject;
import org.apache.qpid.server.stats.FormattingStatisticsResolver;
import org.apache.qpid.server.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatisticsReportingTask
extends TimerTask {
    private final ConfiguredObject<?> _root;
    private final Subject _subject;
    private final ConfiguredObjectTypeRegistry _typeRegistry;
    private final Map<Class<? extends ConfiguredObject>, Set<ConfiguredObjectOperation<?>>> _associatedOperations = new HashMap();

    public StatisticsReportingTask(ConfiguredObject<?> root, Subject subject) {
        this._root = root;
        this._typeRegistry = root.getModel().getTypeRegistry();
        this._subject = subject;
    }

    @Override
    public void run() {
        Subject.doAs(this._subject, () -> {
            this.processChild(this._root);
            return null;
        });
    }

    private void processChild(ConfiguredObject<?> child) {
        this.reportStatisticsForObject(child);
        if (!child.getCategoryClass().getAnnotation(ManagedObject.class).managesChildren()) {
            this.applyRecursively(child);
        }
    }

    private void applyRecursively(ConfiguredObject<?> object) {
        Collection<Class<? extends ConfiguredObject>> childTypes = object.getModel().getChildTypes(object.getCategoryClass());
        childTypes.forEach(childClass -> {
            Collection children = object.getChildren(childClass);
            if (!children.isEmpty()) {
                children.forEach(this::processChild);
            }
        });
        this.processAssociations(object);
    }

    private void processAssociations(ConfiguredObject<?> object) {
        this._associatedOperations.computeIfAbsent(object.getTypeClass(), aClass -> new HashSet(this._typeRegistry.getOperations(object.getTypeClass(), operation -> operation.isAssociateAsIfChildren() && ConfiguredObjectTypeRegistry.returnsCollectionOfConfiguredObjects(operation)).values()));
        for (ConfiguredObjectOperation<?> operation : this._associatedOperations.get(object.getTypeClass())) {
            ConfiguredObjectOperation<?> configuredObjectOperation = operation;
            Collection associatedChildren = (Collection)configuredObjectOperation.perform(object, Collections.emptyMap());
            if (associatedChildren == null || associatedChildren.isEmpty()) continue;
            associatedChildren.forEach(this::processChild);
        }
    }

    private void reportStatisticsForObject(ConfiguredObject<?> object) {
        String statisticsReportPatternContextKey = String.format("qpid.%s.statisticsReportPattern", object.getCategoryClass().getSimpleName().toLowerCase());
        if (object.getContextKeys(false).contains(statisticsReportPatternContextKey)) {
            String reportPattern = object.getContextValue(String.class, statisticsReportPatternContextKey);
            String formattedStatistics = Strings.expand(reportPattern, false, new FormattingStatisticsResolver(object));
            String loggerName = String.format("qpid.statistics.%s", object.getCategoryClass().getSimpleName());
            Logger logger = LoggerFactory.getLogger((String)loggerName);
            logger.info("Statistics: {}", (Object)formattedStatistics);
        }
    }
}

