/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.amqp;

import com.google.common.util.concurrent.ListenableFuture;
import java.security.AccessControlException;
import java.security.AccessController;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.security.auth.Subject;
import org.apache.qpid.server.connection.SessionPrincipal;
import org.apache.qpid.server.consumer.ConsumerOption;
import org.apache.qpid.server.consumer.ConsumerTarget;
import org.apache.qpid.server.exchange.DestinationReferrer;
import org.apache.qpid.server.filter.FilterManager;
import org.apache.qpid.server.management.amqp.ManagementAddressSpace;
import org.apache.qpid.server.message.InstanceProperties;
import org.apache.qpid.server.message.MessageContainer;
import org.apache.qpid.server.message.MessageDestination;
import org.apache.qpid.server.message.MessageInstance;
import org.apache.qpid.server.message.MessageInstanceConsumer;
import org.apache.qpid.server.message.MessageSender;
import org.apache.qpid.server.message.MessageSource;
import org.apache.qpid.server.message.RoutingResult;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.model.NamedAddressSpace;
import org.apache.qpid.server.model.PublishingLink;
import org.apache.qpid.server.model.Queue;
import org.apache.qpid.server.security.SecurityToken;
import org.apache.qpid.server.session.AMQPSession;
import org.apache.qpid.server.store.MessageDurability;
import org.apache.qpid.server.store.StorableMessageMetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyMessageSource
implements MessageSource,
MessageDestination {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProxyMessageSource.class);
    private final String _name;
    private final UUID _id = UUID.randomUUID();
    private final ManagementAddressSpace _managementAddressSpace;
    private volatile MessageInstanceConsumer<?> _consumer;
    private final AtomicBoolean _consumerSet = new AtomicBoolean(false);
    private Object _connectionReference;

    public ProxyMessageSource(ManagementAddressSpace managementAddressSpace, Map<String, Object> attributes) {
        this._name = String.valueOf(attributes.get("name"));
        this._managementAddressSpace = managementAddressSpace;
    }

    public String getName() {
        return this._name;
    }

    public NamedAddressSpace getAddressSpace() {
        return this._managementAddressSpace;
    }

    public void authorisePublish(SecurityToken token, Map<String, Object> arguments) throws AccessControlException {
        throw new AccessControlException("Sending messages to temporary addresses in a management address space is not supported");
    }

    public <M extends ServerMessage<? extends StorableMessageMetaData>> RoutingResult<M> route(M message, String routingAddress, InstanceProperties instanceProperties) {
        return new RoutingResult(message);
    }

    public boolean isDurable() {
        return false;
    }

    public void linkAdded(MessageSender sender, PublishingLink link) {
    }

    public void linkRemoved(MessageSender sender, PublishingLink link) {
    }

    public MessageDestination getAlternateBindingDestination() {
        return null;
    }

    public void removeReference(DestinationReferrer destinationReferrer) {
    }

    public void addReference(DestinationReferrer destinationReferrer) {
    }

    public UUID getId() {
        return this._id;
    }

    public MessageDurability getMessageDurability() {
        return MessageDurability.NEVER;
    }

    public final <T extends ConsumerTarget<T>> MessageInstanceConsumer<T> addConsumer(T target, FilterManager filters, Class<? extends ServerMessage> messageClass, String consumerName, EnumSet<ConsumerOption> options, Integer priority) throws MessageSource.ExistingExclusiveConsumer, MessageSource.ExistingConsumerPreventsExclusive, MessageSource.ConsumerAccessRefused, MessageSource.QueueDeleted {
        if (this._consumerSet.compareAndSet(false, true)) {
            Subject currentSubject = Subject.getSubject(AccessController.getContext());
            Set<SessionPrincipal> sessionPrincipals = currentSubject.getPrincipals(SessionPrincipal.class);
            if (!sessionPrincipals.isEmpty()) {
                this._connectionReference = sessionPrincipals.iterator().next().getSession().getConnectionReference();
                WrappingTarget wrapper = new WrappingTarget(this, target, this._name);
                this._managementAddressSpace.getManagementNode().addConsumer(wrapper, filters, (Class)messageClass, this._name, (EnumSet)options, priority);
                MessageInstanceConsumer consumer = wrapper.getConsumer();
                this._consumer = consumer;
                return consumer;
            }
            return null;
        }
        throw new MessageSource.ExistingExclusiveConsumer();
    }

    public Collection<? extends MessageInstanceConsumer> getConsumers() {
        return this._consumer == null ? Collections.emptySet() : Collections.singleton(this._consumer);
    }

    public boolean verifySessionAccess(AMQPSession<?, ?> session) {
        return session.getConnectionReference() == this._connectionReference;
    }

    public void close() {
    }

    public MessageSource.MessageConversionExceptionHandlingPolicy getMessageConversionExceptionHandlingPolicy() {
        return MessageSource.MessageConversionExceptionHandlingPolicy.CLOSE;
    }

    private static class UnwrappingWrappingConsumer<T extends ConsumerTarget<T>>
    implements MessageInstanceConsumer<T> {
        private final MessageInstanceConsumer<WrappingTarget<T>> _underlying;
        private final WrappingTarget<T> _target;

        public UnwrappingWrappingConsumer(MessageInstanceConsumer<WrappingTarget<T>> sub, WrappingTarget<T> wrappedTarget) {
            this._underlying = sub;
            this._target = wrappedTarget;
        }

        public boolean isClosed() {
            return this._underlying.isClosed();
        }

        public boolean acquires() {
            return this._underlying.acquires();
        }

        public String getName() {
            return this._underlying.getName();
        }

        public void close() {
            this._underlying.close();
        }

        public void externalStateChange() {
            this._underlying.externalStateChange();
        }

        public Object getIdentifier() {
            return this._underlying.getIdentifier();
        }

        public MessageContainer pullMessage() {
            return this._underlying.pullMessage();
        }

        public T getTarget() {
            return this._target.getUnderlying();
        }

        public void setNotifyWorkDesired(boolean desired) {
            this._underlying.setNotifyWorkDesired(desired);
        }
    }

    private static class WrappingTarget<T extends ConsumerTarget<T>>
    implements ConsumerTarget<WrappingTarget<T>> {
        private final T _underlying;
        private final String _address;
        private MessageInstanceConsumer<T> _consumer;
        final /* synthetic */ ProxyMessageSource this$0;

        public WrappingTarget(T target, String address) {
            this.this$0 = var1_1;
            this._underlying = target;
            this._address = address;
        }

        public T getUnderlying() {
            return this._underlying;
        }

        public MessageInstanceConsumer<T> getConsumer() {
            return this._consumer;
        }

        public void acquisitionRemoved(MessageInstance node) {
            this._underlying.acquisitionRemoved(node);
        }

        public boolean processPending() {
            return this._underlying.processPending();
        }

        public String getTargetAddress() {
            return this._address;
        }

        public boolean isMultiQueue() {
            return false;
        }

        public void notifyWork() {
            this._underlying.notifyWork();
        }

        public void updateNotifyWorkDesired() {
            this._underlying.updateNotifyWorkDesired();
        }

        public boolean isNotifyWorkDesired() {
            return this._underlying.isNotifyWorkDesired();
        }

        public ConsumerTarget.State getState() {
            return this._underlying.getState();
        }

        public void consumerAdded(MessageInstanceConsumer<WrappingTarget<T>> sub) {
            this._consumer = new UnwrappingWrappingConsumer<T>(sub, this);
            this._underlying.consumerAdded(this._consumer);
        }

        public ListenableFuture<Void> consumerRemoved(MessageInstanceConsumer<WrappingTarget<T>> sub) {
            return this._underlying.consumerRemoved(this._consumer);
        }

        public long getUnacknowledgedBytes() {
            return this._underlying.getUnacknowledgedBytes();
        }

        public long getUnacknowledgedMessages() {
            return this._underlying.getUnacknowledgedMessages();
        }

        public void resetStatistics() {
            this._underlying.resetStatistics();
        }

        public AMQPSession getSession() {
            return this._underlying.getSession();
        }

        public void send(MessageInstanceConsumer consumer, MessageInstance entry, boolean batch) {
            this._underlying.send(this._consumer, entry, batch);
        }

        public boolean sendNextMessage() {
            return this._underlying.sendNextMessage();
        }

        public void flushBatched() {
            this._underlying.flushBatched();
        }

        public void noMessagesAvailable() {
            this._underlying.noMessagesAvailable();
        }

        public boolean allocateCredit(ServerMessage msg) {
            return this._underlying.allocateCredit(msg);
        }

        public void restoreCredit(ServerMessage queueEntry) {
            this._underlying.restoreCredit(queueEntry);
        }

        public boolean isSuspended() {
            return this._underlying.isSuspended();
        }

        public boolean close() {
            this.this$0._managementAddressSpace.removeProxyMessageSource(this.this$0._connectionReference, this.this$0._name);
            this.this$0._consumer = null;
            return this._underlying.close();
        }

        public void queueDeleted(Queue queue, MessageInstanceConsumer sub) {
            this._underlying.queueDeleted(queue, this._consumer);
        }
    }
}

