/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.extensions.aas.aggregator.authorization;

import java.util.Collection;
import org.eclipse.basyx.aas.aggregator.api.IAASAggregator;
import org.eclipse.basyx.aas.metamodel.api.IAssetAdministrationShell;
import org.eclipse.basyx.aas.metamodel.map.AssetAdministrationShell;
import org.eclipse.basyx.extensions.shared.authorization.SecurityContextAuthorizer;
import org.eclipse.basyx.submodel.metamodel.api.identifier.IIdentifier;
import org.eclipse.basyx.vab.exception.provider.ResourceNotFoundException;
import org.eclipse.basyx.vab.modelprovider.api.IModelProvider;

public class AuthorizedAASAggregator
implements IAASAggregator {
    private static final String SCOPE_AUTHORITY_PREFIX = "SCOPE_";
    public static final String READ_AUTHORITY = "SCOPE_urn:org.eclipse.basyx:scope:aas-aggregator:read";
    public static final String WRITE_AUTHORITY = "SCOPE_urn:org.eclipse.basyx:scope:aas-aggregator:write";
    private final IAASAggregator aasAggregator;
    private final SecurityContextAuthorizer authorizer = new SecurityContextAuthorizer();

    public AuthorizedAASAggregator(IAASAggregator aasAggregator) {
        this.aasAggregator = aasAggregator;
    }

    @Override
    public Collection<IAssetAdministrationShell> getAASList() {
        this.authorizer.throwExceptionInCaseOfInsufficientAuthorization(READ_AUTHORITY);
        return this.aasAggregator.getAASList();
    }

    @Override
    public IAssetAdministrationShell getAAS(IIdentifier shellId) throws ResourceNotFoundException {
        this.authorizer.throwExceptionInCaseOfInsufficientAuthorization(READ_AUTHORITY);
        return this.aasAggregator.getAAS(shellId);
    }

    @Override
    public IModelProvider getAASProvider(IIdentifier shellId) throws ResourceNotFoundException {
        this.authorizer.throwExceptionInCaseOfInsufficientAuthorization(READ_AUTHORITY);
        return this.aasAggregator.getAASProvider(shellId);
    }

    @Override
    public void createAAS(AssetAdministrationShell shell) {
        this.authorizer.throwExceptionInCaseOfInsufficientAuthorization(WRITE_AUTHORITY);
        this.aasAggregator.createAAS(shell);
    }

    @Override
    public void updateAAS(AssetAdministrationShell shell) throws ResourceNotFoundException {
        this.authorizer.throwExceptionInCaseOfInsufficientAuthorization(WRITE_AUTHORITY);
        this.aasAggregator.updateAAS(shell);
    }

    @Override
    public void deleteAAS(IIdentifier shellId) {
        this.authorizer.throwExceptionInCaseOfInsufficientAuthorization(WRITE_AUTHORITY);
        this.aasAggregator.deleteAAS(shellId);
    }
}

