/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.extensions.aas.aggregator.authorization.internal;

import java.util.Collection;
import java.util.function.Supplier;
import org.eclipse.basyx.aas.metamodel.api.IAssetAdministrationShell;
import org.eclipse.basyx.aas.metamodel.map.AssetAdministrationShell;
import org.eclipse.basyx.extensions.aas.aggregator.authorization.internal.IAASAggregatorAuthorizer;
import org.eclipse.basyx.extensions.shared.authorization.internal.BaSyxObjectTargetInformation;
import org.eclipse.basyx.extensions.shared.authorization.internal.IRbacRuleChecker;
import org.eclipse.basyx.extensions.shared.authorization.internal.IRoleAuthenticator;
import org.eclipse.basyx.extensions.shared.authorization.internal.IdHelper;
import org.eclipse.basyx.extensions.shared.authorization.internal.InhibitException;
import org.eclipse.basyx.extensions.shared.authorization.internal.SimpleRbacHelper;
import org.eclipse.basyx.submodel.metamodel.api.identifier.IIdentifier;
import org.eclipse.basyx.vab.modelprovider.api.IModelProvider;

public class SimpleRbacAASAggregatorAuthorizer<SubjectInformationType>
implements IAASAggregatorAuthorizer<SubjectInformationType> {
    protected IRbacRuleChecker rbacRuleChecker;
    protected IRoleAuthenticator<SubjectInformationType> roleAuthenticator;

    public SimpleRbacAASAggregatorAuthorizer(IRbacRuleChecker rbacRuleChecker, IRoleAuthenticator<SubjectInformationType> roleAuthenticator) {
        this.rbacRuleChecker = rbacRuleChecker;
        this.roleAuthenticator = roleAuthenticator;
    }

    @Override
    public Collection<IAssetAdministrationShell> authorizeGetAASList(SubjectInformationType subjectInformation, Supplier<Collection<IAssetAdministrationShell>> aasListSupplier) throws InhibitException {
        return aasListSupplier.get();
    }

    @Override
    public IAssetAdministrationShell authorizeGetAAS(SubjectInformationType subjectInformation, IIdentifier aasId, Supplier<IAssetAdministrationShell> aasSupplier) throws InhibitException {
        SimpleRbacHelper.checkRule(this.rbacRuleChecker, this.roleAuthenticator, subjectInformation, "urn:org.eclipse.basyx:scope:aas-aggregator:read", new BaSyxObjectTargetInformation(IdHelper.getIdentifierId(aasId), null, null));
        return aasSupplier.get();
    }

    @Override
    public IModelProvider authorizeGetAASProvider(SubjectInformationType subjectInformation, IIdentifier aasId, Supplier<IModelProvider> modelProviderSupplier) throws InhibitException {
        SimpleRbacHelper.checkRule(this.rbacRuleChecker, this.roleAuthenticator, subjectInformation, "urn:org.eclipse.basyx:scope:aas-aggregator:read", new BaSyxObjectTargetInformation(IdHelper.getIdentifierId(aasId), null, null));
        return modelProviderSupplier.get();
    }

    @Override
    public void authorizeCreateAAS(SubjectInformationType subjectInformation, AssetAdministrationShell aas) throws InhibitException {
        IIdentifier aasId = aas.getIdentification();
        SimpleRbacHelper.checkRule(this.rbacRuleChecker, this.roleAuthenticator, subjectInformation, "urn:org.eclipse.basyx:scope:aas-aggregator:write", new BaSyxObjectTargetInformation(IdHelper.getIdentifierId(aasId), null, null));
    }

    @Override
    public void authorizeUpdateAAS(SubjectInformationType subjectInformation, AssetAdministrationShell aas) throws InhibitException {
        IIdentifier aasId = aas.getIdentification();
        SimpleRbacHelper.checkRule(this.rbacRuleChecker, this.roleAuthenticator, subjectInformation, "urn:org.eclipse.basyx:scope:aas-aggregator:write", new BaSyxObjectTargetInformation(IdHelper.getIdentifierId(aasId), null, null));
    }

    @Override
    public void authorizeDeleteAAS(SubjectInformationType subjectInformation, IIdentifier aasId) throws InhibitException {
        SimpleRbacHelper.checkRule(this.rbacRuleChecker, this.roleAuthenticator, subjectInformation, "urn:org.eclipse.basyx:scope:aas-aggregator:write", new BaSyxObjectTargetInformation(IdHelper.getIdentifierId(aasId), null, null));
    }
}

