/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.extensions.aas.directory.tagged.api;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.basyx.aas.metamodel.map.descriptor.SubmodelDescriptor;
import org.eclipse.basyx.submodel.metamodel.api.ISubmodel;
import org.eclipse.basyx.submodel.metamodel.api.identifier.IIdentifier;

public class TaggedSubmodelDescriptor
extends SubmodelDescriptor {
    public static final String MODELTYPE = "TaggedSubmodelDescriptor";
    public static final String TAGS = "tags";

    public TaggedSubmodelDescriptor(ISubmodel submodel, String httpEndpoint) {
        super(submodel, httpEndpoint);
        this.initialize();
    }

    public TaggedSubmodelDescriptor(String idShort, IIdentifier id, String httpEndpoint) {
        super(idShort, id, httpEndpoint);
        this.initialize();
    }

    protected TaggedSubmodelDescriptor() {
    }

    public static TaggedSubmodelDescriptor createAsFacade(Map<String, Object> map) {
        if (map == null) {
            return null;
        }
        Collection tags = (Collection)map.get(TAGS);
        if (tags instanceof List) {
            map.put(TAGS, new HashSet(tags));
        }
        TaggedSubmodelDescriptor descriptor = new TaggedSubmodelDescriptor();
        descriptor.putAll(map);
        return descriptor;
    }

    private void initialize() {
        this.put(TAGS, new HashSet());
    }

    public void addTag(String tag) {
        this.getTags().add(tag);
    }

    public void addTags(List<String> tags) {
        tags.stream().forEach(this::addTag);
    }

    public Set<String> getTags() {
        return (Set)this.get(TAGS);
    }

    @Override
    protected String getModelType() {
        return MODELTYPE;
    }
}

