/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.extensions.aas.directory.tagged.restapi;

import com.google.common.base.Splitter;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.basyx.aas.metamodel.map.descriptor.AASDescriptor;
import org.eclipse.basyx.aas.registration.restapi.AASRegistryModelProvider;
import org.eclipse.basyx.extensions.aas.directory.tagged.api.IAASTaggedDirectory;
import org.eclipse.basyx.extensions.aas.directory.tagged.api.TagType;
import org.eclipse.basyx.extensions.aas.directory.tagged.api.TaggedAASDescriptor;
import org.eclipse.basyx.extensions.aas.directory.tagged.api.TaggedSubmodelDescriptor;
import org.eclipse.basyx.extensions.aas.directory.tagged.map.MapTaggedDirectory;
import org.eclipse.basyx.submodel.metamodel.map.identifier.Identifier;
import org.eclipse.basyx.vab.exception.provider.ProviderException;
import org.eclipse.basyx.vab.modelprovider.VABPathTools;

public class TaggedDirectoryProvider
extends AASRegistryModelProvider {
    private IAASTaggedDirectory directory;
    public static final String PREFIX = "api/v1/directory";
    public static final String API_ACCESS = "tags=";
    public static final String SUBMODEL_API_ACCESS = "submodelTags=";

    public TaggedDirectoryProvider() {
        this(new MapTaggedDirectory(new LinkedHashMap<String, AASDescriptor>(), new LinkedHashMap<String, Set<TaggedAASDescriptor>>()));
    }

    public TaggedDirectoryProvider(IAASTaggedDirectory directory) {
        super(directory);
        this.directory = directory;
    }

    @Override
    public Object getValue(String path) throws ProviderException {
        if ((path = VABPathTools.stripSlashes(path)).startsWith(PREFIX)) {
            if (path.contains(API_ACCESS) && path.contains(SUBMODEL_API_ACCESS)) {
                return this.directory.lookupBothAasAndSubmodelTags(this.extractTags(path, TagType.AAS.getStandardizedLiteral()), this.extractTags(path, TagType.SUBMODEL.getStandardizedLiteral()));
            }
            if (path.contains(SUBMODEL_API_ACCESS)) {
                return this.directory.lookupSubmodelTags(this.extractTags(path, TagType.SUBMODEL.getStandardizedLiteral()));
            }
            return this.directory.lookupTags(this.extractTags(path, TagType.AAS.getStandardizedLiteral()));
        }
        return super.getValue(path);
    }

    @Override
    public void createValue(String path, Object newEntity) throws ProviderException {
        path = VABPathTools.decodePathElement(path);
        if ((path = VABPathTools.stripSlashes(path)).startsWith(PREFIX)) {
            if (path.contains("/submodels/")) {
                this.registerSubmodel(path, newEntity);
            } else {
                this.directory.register(TaggedAASDescriptor.createAsFacade((Map)newEntity));
            }
        } else {
            super.createValue(path, newEntity);
        }
    }

    private void registerSubmodel(String path, Object newEntity) {
        String aasIdWithSlashes = path.replace(PREFIX, "").replace(path.substring(path.indexOf("/submodels/")), "");
        String aasIdWithoutSlashes = VABPathTools.stripSlashes(aasIdWithSlashes);
        Identifier id = new Identifier();
        id.setId(aasIdWithoutSlashes);
        this.directory.registerSubmodel(id, TaggedSubmodelDescriptor.createAsFacade((Map)newEntity));
    }

    private Set<String> extractTags(String path, String tagType) {
        path = VABPathTools.stripSlashes(path);
        path = path.split("\\?")[1];
        Map queryParams = Splitter.on((String)"&").trimResults().withKeyValueSeparator("=").split((CharSequence)path);
        String tags = (String)queryParams.get(tagType);
        return this.getTagsAsSet(tags);
    }

    private Set<String> getTagsAsSet(String tags) {
        if (tags.isEmpty()) {
            return new LinkedHashSet<String>();
        }
        return Arrays.stream(tags.split(",")).collect(Collectors.toSet());
    }
}

