/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.extensions.shared.mqtt;

import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.MqttPersistenceException;
import org.eclipse.paho.client.mqttv3.persist.MqttDefaultFilePersistence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttEventService {
    private static Logger logger = LoggerFactory.getLogger(MqttEventService.class);
    protected MqttClient mqttClient;
    protected int qos = 1;

    public MqttEventService(String serverEndpoint, String clientId) throws MqttException {
        this(serverEndpoint, clientId, (MqttClientPersistence)new MqttDefaultFilePersistence());
    }

    public MqttEventService(String serverEndpoint, String clientId, MqttClientPersistence mqttPersistence) throws MqttException {
        this.mqttClient = new MqttClient(serverEndpoint, clientId, mqttPersistence);
        this.mqttClient.connect();
    }

    public MqttEventService(String serverEndpoint, String clientId, String user, char[] pw, MqttClientPersistence mqttPersistence) throws MqttException {
        this.mqttClient = new MqttClient(serverEndpoint, clientId, mqttPersistence);
        MqttConnectOptions options = new MqttConnectOptions();
        options.setUserName(user);
        options.setPassword(pw);
        this.mqttClient.connect(options);
    }

    public MqttEventService(String serverEndpoint, String clientId, String user, char[] pw) throws MqttException {
        this(serverEndpoint, clientId, user, pw, (MqttClientPersistence)new MqttDefaultFilePersistence());
    }

    public MqttEventService(MqttClient client) throws MqttException {
        this.mqttClient = client;
    }

    public void setQoS(int qos) {
        if (qos < 0 || qos > 3) {
            throw new IllegalArgumentException("Invalid QoS: " + qos);
        }
        this.qos = qos;
    }

    public int getQoS() {
        return this.qos;
    }

    protected void sendMqttMessage(String topic, String payload) {
        MqttMessage msg = this.createMqttMessage(payload);
        if (this.qos != 1) {
            msg.setQos(this.qos);
        }
        try {
            logger.debug("Send MQTT message to " + topic + ": " + payload);
            this.mqttClient.publish(topic, msg);
        }
        catch (MqttPersistenceException e) {
            logger.error("Could not persist mqtt message", (Throwable)e);
        }
        catch (MqttException e) {
            logger.error("Could not send mqtt message", (Throwable)e);
        }
    }

    private MqttMessage createMqttMessage(String payload) {
        if (payload == null) {
            return new MqttMessage();
        }
        return new MqttMessage(payload.getBytes());
    }
}

