/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.submodel.factory.xml.converters.submodelelement;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.basyx.submodel.factory.xml.XMLHelper;
import org.eclipse.basyx.submodel.factory.xml.converters.submodelelement.SubmodelElementXMLConverter;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.ISubmodelElement;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.ISubmodelElementCollection;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.SubmodelElementCollection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SubmodelElementCollectionXMLConverter
extends SubmodelElementXMLConverter {
    public static final String SUBMODEL_ELEMENT_COLLECTION = "aas:submodelElementCollection";
    public static final String ORDERED = "aas:ordered";
    public static final String ALLOW_DUPLICATES = "aas:allowDuplicates";

    public static SubmodelElementCollection parseSubmodelElementCollection(Map<String, Object> xmlObject) {
        boolean ordered = Boolean.valueOf(XMLHelper.getString(xmlObject.get(ORDERED)));
        boolean allowDuplicates = Boolean.valueOf(XMLHelper.getString(xmlObject.get(ALLOW_DUPLICATES)));
        Map valueMap = (Map)xmlObject.get("aas:value");
        List<ISubmodelElement> submodelElements = SubmodelElementCollectionXMLConverter.getSubmodelElements(valueMap);
        SubmodelElementCollection smElemColl = new SubmodelElementCollection(submodelElements, ordered, allowDuplicates);
        SubmodelElementCollectionXMLConverter.populateSubmodelElement(xmlObject, smElemColl);
        return smElemColl;
    }

    public static Element buildSubmodelElementCollection(Document document, ISubmodelElementCollection smElemCollection) {
        Element smElemCollectionRoot = document.createElement(SUBMODEL_ELEMENT_COLLECTION);
        SubmodelElementCollectionXMLConverter.populateSubmodelElement(document, smElemCollectionRoot, smElemCollection);
        String isAllowedDuplicates = Boolean.toString(smElemCollection.isAllowDuplicates());
        Element allowDuplicatesElem = document.createElement(ALLOW_DUPLICATES);
        allowDuplicatesElem.appendChild(document.createTextNode(isAllowedDuplicates));
        smElemCollectionRoot.appendChild(allowDuplicatesElem);
        String isOrdered = Boolean.toString(smElemCollection.isOrdered());
        Element orderedElem = document.createElement(ORDERED);
        orderedElem.appendChild(document.createTextNode(isOrdered));
        smElemCollectionRoot.appendChild(orderedElem);
        Collection<ISubmodelElement> elems = smElemCollection.getSubmodelElements().values();
        if (elems != null) {
            Element valueRoot = document.createElement("aas:value");
            smElemCollectionRoot.appendChild(valueRoot);
            SubmodelElementCollectionXMLConverter.buildSubmodelElements(document, valueRoot, elems);
        }
        return smElemCollectionRoot;
    }
}

