/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.submodel.metamodel.map.submodelelement.operation;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.operation.IOperationVariable;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.SubmodelElement;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.operation.OperationVariable;
import org.eclipse.basyx.vab.exception.provider.MalformedRequestException;
import org.eclipse.basyx.vab.exception.provider.WrongNumberOfParametersException;

public class OperationCheckHelper {
    private OperationCheckHelper() {
    }

    public static void checkSubmodelElementAsParameter(SubmodelElement[] givenParameters, Collection<IOperationVariable> expectedVariables) {
        Map<String, SubmodelElement> paramsByIdShortMap = OperationCheckHelper.createParameterMap(givenParameters);
        OperationCheckHelper.compareGivenWithExpectedVariables(paramsByIdShortMap, expectedVariables);
    }

    public static void checkSubmodelElementAsParameter(Map<String, SubmodelElement> givenParameterMap, Collection<IOperationVariable> expectedVariables) {
        OperationCheckHelper.compareGivenWithExpectedVariables(givenParameterMap, expectedVariables);
    }

    public static void checkValidParameterLength(int actualParameterLength, String idShort, Collection<IOperationVariable> inputVariables) {
        if (actualParameterLength != inputVariables.size()) {
            throw new WrongNumberOfParametersException(idShort, inputVariables, actualParameterLength);
        }
    }

    public static void checkSubmodelElementExpectedTypes(Object[] givenParameters, Collection<IOperationVariable> expectedVariables) {
        IOperationVariable[] expectedVarArray = expectedVariables.toArray(new IOperationVariable[expectedVariables.size()]);
        for (int i = 0; i < expectedVarArray.length; ++i) {
            OperationCheckHelper.checkSubmodelElementExpectedType(expectedVarArray[i], givenParameters[i]);
        }
    }

    private static void checkSubmodelElementExpectedType(IOperationVariable iOperationVariable, Object value) {
        SubmodelElement submodelElement = iOperationVariable.getValue().getLocalCopy();
        try {
            submodelElement.setValue(value);
        }
        catch (Exception e) {
            throw new MalformedRequestException(e);
        }
    }

    private static void compareGivenWithExpectedVariables(Map<String, SubmodelElement> paramsByIdShortMap, Collection<IOperationVariable> expectedVariables) {
        for (IOperationVariable expectedVariable : expectedVariables) {
            OperationCheckHelper.compareExpectedVariableToGivenVariableMap(expectedVariable, paramsByIdShortMap);
        }
    }

    private static void compareExpectedVariableToGivenVariableMap(IOperationVariable expectedVariable, Map<String, SubmodelElement> paramsByIdShortMap) {
        SubmodelElement expectedParam = (SubmodelElement)expectedVariable.getValue();
        SubmodelElement givenParam = paramsByIdShortMap.get(expectedParam.getIdShort());
        OperationCheckHelper.compareSubmodelElements(expectedParam, givenParam);
    }

    private static void compareSubmodelElements(SubmodelElement expectedParam, SubmodelElement givenParam) {
        OperationCheckHelper.checkIfSubmodelElementExists(expectedParam, givenParam);
        OperationCheckHelper.checkModelType(expectedParam, givenParam);
    }

    private static Map<String, SubmodelElement> createParameterMap(SubmodelElement[] params) {
        LinkedHashMap<String, SubmodelElement> parameterMap = new LinkedHashMap<String, SubmodelElement>();
        for (SubmodelElement param : params) {
            String parameterKey = OperationCheckHelper.getKeyForParameter(param);
            parameterMap.put(parameterKey, param);
        }
        return parameterMap;
    }

    private static String getKeyForParameter(SubmodelElement param) {
        OperationVariable paramOperationVariable = new OperationVariable(param);
        return paramOperationVariable.getValue().getIdShort();
    }

    private static void checkIfSubmodelElementExists(SubmodelElement expectedParam, SubmodelElement givenParam) {
        if (givenParam == null) {
            throw new MalformedRequestException("Expected parameter " + expectedParam.getIdShort() + " missing in request");
        }
    }

    private static void checkModelType(SubmodelElement expectedParam, SubmodelElement givenParam) {
        if (!expectedParam.getModelType().equals(givenParam.getModelType())) {
            throw new MalformedRequestException("Given modelType " + givenParam.getModelType() + " differs from expected modelType " + expectedParam.getModelType());
        }
    }
}

