/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.submodel.restapi.vab;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.basyx.submodel.metamodel.api.ISubmodel;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.ISubmodelElement;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.operation.IOperation;
import org.eclipse.basyx.submodel.metamodel.map.Submodel;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.SubmodelElement;
import org.eclipse.basyx.submodel.restapi.MultiSubmodelElementProvider;
import org.eclipse.basyx.submodel.restapi.SubmodelAPIHelper;
import org.eclipse.basyx.submodel.restapi.api.ISubmodelAPI;
import org.eclipse.basyx.vab.modelprovider.VABElementProxy;
import org.eclipse.basyx.vab.modelprovider.api.IModelProvider;

public class VABSubmodelAPI
implements ISubmodelAPI {
    private IModelProvider modelProvider;

    public VABSubmodelAPI(IModelProvider modelProvider) {
        this.modelProvider = modelProvider;
    }

    private MultiSubmodelElementProvider getElementProvider() {
        VABElementProxy elementProxy = new VABElementProxy(SubmodelAPIHelper.getSubmodelElementsPath(), this.modelProvider);
        return new MultiSubmodelElementProvider(elementProxy);
    }

    @Override
    public ISubmodel getSubmodel() {
        Map map = (Map)this.modelProvider.getValue(SubmodelAPIHelper.getSubmodelPath());
        LinkedHashMap<String, Object> smCopy = new LinkedHashMap<String, Object>();
        smCopy.putAll(map);
        return Submodel.createAsFacade(smCopy);
    }

    @Override
    public void addSubmodelElement(ISubmodelElement elem) {
        this.getElementProvider().createValue(SubmodelAPIHelper.getSubmodelElementPath(elem.getIdShort()), elem);
    }

    @Override
    public void addSubmodelElement(String idShortPath, ISubmodelElement elem) {
        this.getElementProvider().createValue(SubmodelAPIHelper.getSubmodelElementPath(idShortPath), elem);
    }

    @Override
    public void deleteSubmodelElement(String idShortPath) {
        this.getElementProvider().deleteValue(SubmodelAPIHelper.getSubmodelElementPath(idShortPath));
    }

    @Override
    public Collection<IOperation> getOperations() {
        return this.getSubmodelElements().stream().filter(e -> e instanceof IOperation).map(e -> (IOperation)e).collect(Collectors.toList());
    }

    @Override
    public Collection<ISubmodelElement> getSubmodelElements() {
        Collection elements = (Collection)this.getElementProvider().getValue(SubmodelAPIHelper.getSubmodelElementsPath());
        return elements.stream().map(SubmodelElement::createAsFacade).collect(Collectors.toList());
    }

    @Override
    public void updateSubmodelElement(String idShortPath, Object newValue) {
        this.getElementProvider().setValue(SubmodelAPIHelper.getSubmodelElementValuePath(idShortPath), newValue);
    }

    @Override
    public Object getSubmodelElementValue(String idShortPath) {
        return this.getElementProvider().getValue(SubmodelAPIHelper.getSubmodelElementValuePath(idShortPath));
    }

    @Override
    public ISubmodelElement getSubmodelElement(String idShortPath) {
        return SubmodelElement.createAsFacade((Map)this.getElementProvider().getValue(SubmodelAPIHelper.getSubmodelElementPath(idShortPath)));
    }

    @Override
    public Object invokeOperation(String idShortPath, Object ... params) {
        return this.getElementProvider().invokeOperation(SubmodelAPIHelper.getSubmodelElementSyncInvokePath(idShortPath), params);
    }

    @Override
    public Object invokeAsync(String idShortPath, Object ... params) {
        return this.getElementProvider().invokeOperation(SubmodelAPIHelper.getSubmodelElementAsyncInvokePath(idShortPath), params);
    }

    @Override
    public Object getOperationResult(String idShortPath, String requestId) {
        return this.getElementProvider().getValue(SubmodelAPIHelper.getSubmodelElementResultValuePath(idShortPath, requestId));
    }
}

