/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.core.dataStructures.hash;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import jetbrains.exodus.core.dataStructures.hash.HashUtil;
import jetbrains.exodus.util.MathUtil;

public class HashSet<E>
extends AbstractSet<E> {
    private Entry<E>[] table;
    private int capacity;
    private int size;
    private final float loadFactor;
    private int mask;
    private boolean holdsNull;

    public HashSet() {
        this(0);
    }

    public HashSet(int capacity) {
        this(capacity, 1.0f);
    }

    public HashSet(int capacity, float loadFactor) {
        this.loadFactor = loadFactor;
        this.init(capacity);
    }

    public HashSet(Collection<E> collection) {
        this(collection.size());
        this.addAll(collection);
    }

    @Override
    public boolean contains(Object key) {
        if (key == null) {
            return this.holdsNull;
        }
        Entry<E>[] table = this.table;
        int hash = key.hashCode();
        int index = HashUtil.indexFor(hash, table.length, this.mask);
        Entry e = table[index];
        while (e != null) {
            Object entryKey = e.key;
            if (entryKey == key || entryKey.equals(key)) {
                return true;
            }
            e = e.hashNext;
        }
        return false;
    }

    @Override
    public boolean add(E key) {
        if (key == null) {
            boolean wasHoldingNull = this.holdsNull;
            this.holdsNull = true;
            if (!wasHoldingNull) {
                ++this.size;
            }
            return !wasHoldingNull;
        }
        Entry<E>[] table = this.table;
        int hash = key.hashCode();
        int index = HashUtil.indexFor(hash, table.length, this.mask);
        Entry e = table[index];
        while (e != null) {
            Object entryKey = e.key;
            if (entryKey == key || entryKey.equals(key)) {
                return false;
            }
            e = e.hashNext;
        }
        e = new Entry(key);
        e.hashNext = (Entry)table[index];
        table[index] = e;
        ++this.size;
        if (this.size > this.capacity) {
            this.rehash(HashUtil.nextCapacity(this.capacity));
        }
        return true;
    }

    @Override
    public boolean remove(Object key) {
        if (key == null) {
            boolean wasHoldingNull = this.holdsNull;
            this.holdsNull = false;
            if (wasHoldingNull) {
                --this.size;
            }
            return wasHoldingNull;
        }
        Entry<E>[] table = this.table;
        int hash = key.hashCode();
        int index = HashUtil.indexFor(hash, table.length, this.mask);
        Entry e = table[index];
        if (e == null) {
            return false;
        }
        Object entryKey = e.key;
        if (entryKey == key || entryKey.equals(key)) {
            table[index] = e.hashNext;
        } else {
            Entry last;
            do {
                last = e;
                if ((e = e.hashNext) != null) continue;
                return false;
            } while ((entryKey = e.key) != key && !entryKey.equals(key));
            last.hashNext = e.hashNext;
        }
        --this.size;
        return true;
    }

    @Override
    public Iterator<E> iterator() {
        return new HashSetIterator<E>(){

            @Override
            public E next() {
                return this.nextEntry().key;
            }
        };
    }

    @Override
    public int size() {
        return this.size;
    }

    private void allocateTable(int length) {
        this.table = new Entry[length];
        this.mask = (1 << MathUtil.integerLogarithm(this.table.length)) - 1;
    }

    private void init(int capacity) {
        if (capacity < 4) {
            capacity = 4;
        }
        this.allocateTable(HashUtil.getCeilingPrime((int)((float)capacity / this.loadFactor)));
        this.capacity = capacity;
        this.size = 0;
        this.holdsNull = false;
    }

    private void rehash(int capacity) {
        int length = HashUtil.getCeilingPrime((int)((float)capacity / this.loadFactor));
        this.capacity = capacity;
        if (length != this.table.length) {
            RehashIterator entries = new RehashIterator();
            this.allocateTable(length);
            Entry<E>[] table = this.table;
            int mask = this.mask;
            while (entries.hasNext()) {
                Entry e = (Entry)entries.next();
                int index = HashUtil.indexFor(e.key.hashCode(), length, mask);
                e.hashNext = (Entry)table[index];
                table[index] = e;
            }
        }
    }

    private abstract class HashSetIterator<T>
    implements Iterator<T> {
        private final Entry<E>[] table;
        private int index;
        private Entry<E> e;
        private Entry<E> last;
        private boolean holdsNull;

        HashSetIterator() {
            this.table = HashSet.this.table;
            this.index = 0;
            this.e = null;
            this.holdsNull = HashSet.this.holdsNull;
            this.initNextEntry();
        }

        @Override
        public boolean hasNext() {
            return this.e != null;
        }

        @Override
        public void remove() {
            if (this.last == null) {
                throw new IllegalStateException();
            }
            HashSet.this.remove(this.last.key);
            this.last = null;
        }

        protected Entry<E> nextEntry() {
            this.last = this.e;
            Entry result = this.last;
            this.initNextEntry();
            return result;
        }

        private void initNextEntry() {
            Entry result = this.e;
            if (result != null) {
                result = result.hashNext;
            }
            Entry<E>[] table = this.table;
            int length = table.length;
            while (result == null && this.index < length) {
                result = table[this.index++];
            }
            if (result == null && this.holdsNull) {
                this.holdsNull = false;
                result = new Entry();
            }
            this.e = result;
        }
    }

    private static class Entry<E> {
        private final E key;
        private Entry<E> hashNext;

        private Entry() {
            this.key = null;
            this.hashNext = null;
        }

        private Entry(E key) {
            this.key = key;
            this.hashNext = null;
        }
    }

    private final class RehashIterator
    extends HashSetIterator<Entry<E>> {
        private RehashIterator() {
        }

        @Override
        public Entry<E> next() {
            return this.nextEntry();
        }
    }
}

