/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.core.execution;

import jetbrains.exodus.core.dataStructures.Priority;
import jetbrains.exodus.core.execution.JobHandler;
import jetbrains.exodus.core.execution.JobProcessor;
import jetbrains.exodus.core.execution.JobProcessorExceptionHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Job {
    private JobProcessor processor;
    private boolean wasQueued;
    @Nullable
    private JobHandler[] jobStartingHandlers;
    @Nullable
    private JobHandler[] jobFinishedHandlers;

    protected Job() {
        this.processor = null;
        this.wasQueued = false;
        this.jobStartingHandlers = null;
        this.jobFinishedHandlers = null;
    }

    protected Job(@NotNull JobProcessor processor) {
        this(processor, Priority.normal);
    }

    protected Job(@NotNull JobProcessor processor, @NotNull Priority priority) {
        this.processor = processor;
        this.jobStartingHandlers = null;
        this.jobFinishedHandlers = null;
        this.queue(priority);
    }

    public boolean queue(Priority priority) {
        this.wasQueued = this.processor.queue(this, priority);
        return this.wasQueued;
    }

    public JobProcessor getProcessor() {
        return this.processor;
    }

    public void setProcessor(JobProcessor processor) {
        this.processor = processor;
    }

    public boolean wasQueued() {
        return this.wasQueued;
    }

    public String getName() {
        String name = this.getClass().getSimpleName();
        return name.isEmpty() ? "<anonymous>" : name;
    }

    public String getGroup() {
        return this.getClass().getName();
    }

    public void registerJobStartingHandler(@NotNull JobHandler handler) {
        this.jobStartingHandlers = JobHandler.append(this.jobStartingHandlers, handler);
    }

    public void registerJobFinishedHandler(@NotNull JobHandler handler) {
        this.jobFinishedHandlers = JobHandler.append(this.jobFinishedHandlers, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void run(@Nullable JobProcessorExceptionHandler handler) {
        Throwable exception = null;
        JobHandler.invokeHandlers(this.jobStartingHandlers, this);
        try {
            this.execute();
        }
        catch (Throwable t) {
            exception = t;
        }
        finally {
            JobHandler.invokeHandlers(this.jobFinishedHandlers, this);
        }
        if (exception != null && handler != null) {
            handler.handle(this.processor, this, exception);
        }
    }

    public final boolean equals(Object job) {
        if (job == this) {
            return true;
        }
        return job != null && this.getClass() == job.getClass() && this.isEqualTo((Job)job);
    }

    public boolean isEqualTo(Job job) {
        return super.equals(job);
    }

    protected abstract void execute() throws Throwable;
}

