/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.aas.basyx;

import de.iip_ecosphere.platform.support.FileFormat;
import de.iip_ecosphere.platform.support.aas.Aas;
import de.iip_ecosphere.platform.support.aas.PersistenceRecipe;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxAas;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxAsset;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxSubmodel;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.basyx.aas.metamodel.api.IAssetAdministrationShell;
import org.eclipse.basyx.aas.metamodel.api.parts.asset.IAsset;
import org.eclipse.basyx.aas.metamodel.connected.ConnectedAssetAdministrationShell;
import org.eclipse.basyx.aas.metamodel.map.AssetAdministrationShell;
import org.eclipse.basyx.aas.metamodel.map.parts.Asset;
import org.eclipse.basyx.submodel.metamodel.api.ISubmodel;
import org.eclipse.basyx.submodel.metamodel.api.identifier.IIdentifier;
import org.eclipse.basyx.submodel.metamodel.api.reference.IKey;
import org.eclipse.basyx.submodel.metamodel.api.reference.IReference;
import org.eclipse.basyx.submodel.metamodel.api.reference.enums.KeyElements;
import org.eclipse.basyx.submodel.metamodel.connected.ConnectedSubmodel;
import org.eclipse.basyx.submodel.metamodel.map.Submodel;

public abstract class AbstractPersistenceRecipe
implements PersistenceRecipe {
    private List<FileFormat> formats = new ArrayList<FileFormat>();

    protected AbstractPersistenceRecipe(FileFormat ... formats) {
        for (FileFormat f : formats) {
            this.formats.add(f);
        }
        this.formats = Collections.unmodifiableList(this.formats);
    }

    public Collection<FileFormat> getSupportedFormats() {
        return this.formats;
    }

    protected void transform(List<? extends IAssetAdministrationShell> aas, List<? extends ISubmodel> submodels, List<? extends IAsset> assets, List<Aas> result) throws IOException {
        IIdentifier id;
        HashMap<CallSite, Submodel> subMapping = new HashMap<CallSite, Submodel>();
        HashMap<CallSite, Asset> assetMapping = new HashMap<CallSite, Asset>();
        for (ISubmodel iSubmodel : submodels) {
            if (!(iSubmodel instanceof Submodel)) continue;
            id = iSubmodel.getIdentification();
            subMapping.put((CallSite)((Object)(String.valueOf(id.getIdType()) + "/" + id.getId())), (Submodel)iSubmodel);
        }
        for (IAsset iAsset : assets) {
            if (!(iAsset instanceof Asset)) continue;
            id = iAsset.getIdentification();
            assetMapping.put((CallSite)((Object)(String.valueOf(id.getIdType()) + "/" + id.getId())), (Asset)iAsset);
        }
        for (IAssetAdministrationShell iAssetAdministrationShell : aas) {
            if (!(iAssetAdministrationShell instanceof AssetAdministrationShell)) continue;
            BaSyxAas bAas = new BaSyxAas((AssetAdministrationShell)iAssetAdministrationShell);
            block3: for (IReference r : iAssetAdministrationShell.getSubmodelReferences()) {
                if (r.getKeys().isEmpty()) continue;
                Submodel submodel = null;
                for (IKey k : r.getKeys()) {
                    if (KeyElements.SUBMODEL == k.getType()) {
                        submodel = (Submodel)subMapping.get(String.valueOf(k.getIdType()) + "/" + k.getValue());
                    }
                    if (null == submodel) continue;
                    bAas.register(new BaSyxSubmodel(bAas, submodel));
                    continue block3;
                }
            }
            IReference r = iAssetAdministrationShell.getAssetReference();
            if (null != r && !r.getKeys().isEmpty()) {
                Asset asset = null;
                for (IKey k : r.getKeys()) {
                    if (KeyElements.ASSET != k.getType()) continue;
                    asset = (Asset)assetMapping.get(String.valueOf(k.getIdType()) + "/" + k.getValue());
                }
                if (null != asset) {
                    bAas.registerAsset(new BaSyxAsset((IAsset)asset));
                }
            }
            result.add(bAas);
        }
    }

    protected static <T> void addAsset(Aas aas, Collection<T> assetList, Class<T> assetCls) {
        if (aas.getAsset() instanceof BaSyxAsset) {
            IAsset asset = ((BaSyxAsset)aas.getAsset()).getAsset();
            if (asset instanceof Asset) {
                if (AbstractPersistenceRecipe.isValidForWriting(asset)) {
                    assetList.add(assetCls.cast(asset));
                }
            } else {
                throw new IllegalArgumentException("Can only write real Asset instances");
            }
        }
    }

    protected static boolean isValidForWriting(IAsset asset) {
        return asset.getIdShort().length() > 0;
    }

    protected static AssetAdministrationShell ensureLocal(IAssetAdministrationShell aas) {
        Object result = aas instanceof ConnectedAssetAdministrationShell ? ((ConnectedAssetAdministrationShell)aas).getLocalCopy() : (aas instanceof AssetAdministrationShell ? (AssetAdministrationShell)aas : null);
        return result;
    }

    protected static Submodel ensureLocal(ISubmodel submodel) {
        Object result = submodel instanceof ConnectedSubmodel ? ((ConnectedSubmodel)submodel).getLocalCopy() : (submodel instanceof Submodel ? (Submodel)submodel : null);
        return result;
    }
}

