/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.aas.basyx;

import de.iip_ecosphere.platform.support.aas.AasVisitor;
import de.iip_ecosphere.platform.support.aas.AssetInformation;
import de.iip_ecosphere.platform.support.aas.AssetKind;
import de.iip_ecosphere.platform.support.aas.LangString;
import de.iip_ecosphere.platform.support.aas.Reference;
import de.iip_ecosphere.platform.support.aas.basyx.AbstractAas;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxReference;
import de.iip_ecosphere.platform.support.aas.basyx.Tools;
import org.eclipse.basyx.aas.metamodel.api.parts.asset.IAsset;
import org.eclipse.basyx.aas.metamodel.map.parts.Asset;

public class BaSyxAsset
implements AssetInformation {
    private IAsset asset;

    private BaSyxAsset() {
    }

    BaSyxAsset(IAsset asset) {
        this.asset = asset;
    }

    public AssetKind getAssetKind() {
        return Tools.translate(this.asset.getAssetKind());
    }

    public String getIdShort() {
        return this.asset.getIdShort();
    }

    IAsset getAsset() {
        return this.asset;
    }

    public void accept(AasVisitor visitor) {
        visitor.visitAsset((AssetInformation)this);
    }

    public Reference createReference() {
        return new BaSyxReference(this.asset.getReference());
    }

    static class BaSyxAssetBuilder
    implements AssetInformation.AssetInformationBuilder {
        private AbstractAas.BaSyxAbstractAasBuilder parent;
        private BaSyxAsset instance;
        private Asset asset;

        BaSyxAssetBuilder(AbstractAas.BaSyxAbstractAasBuilder parent, String idShort, String identifier, AssetKind kind) {
            this.parent = parent;
            this.instance = new BaSyxAsset();
            this.asset = new Asset(idShort, Tools.translateIdentifier(identifier, idShort), Tools.translate(kind));
            this.instance.asset = this.asset;
        }

        public AssetInformation build() {
            this.parent.setAsset(this.instance);
            return this.instance;
        }

        public AssetInformation.AssetInformationBuilder setDescription(LangString ... description) {
            this.asset.setDescription(Tools.translate(description));
            return this;
        }

        public Reference createReference() {
            return new BaSyxReference(this.asset.getReference());
        }
    }
}

