/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.aas.basyx;

import de.iip_ecosphere.platform.support.Endpoint;
import de.iip_ecosphere.platform.support.Schema;
import de.iip_ecosphere.platform.support.ServerAddress;
import de.iip_ecosphere.platform.support.aas.Aas;
import de.iip_ecosphere.platform.support.aas.Registry;
import de.iip_ecosphere.platform.support.aas.Submodel;
import de.iip_ecosphere.platform.support.aas.basyx.AbstractAas;
import de.iip_ecosphere.platform.support.aas.basyx.AbstractSubmodel;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxAas;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxConnectedAas;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxISubmodel;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxSubmodel;
import de.iip_ecosphere.platform.support.aas.basyx.Tools;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.eclipse.basyx.aas.manager.ConnectedAssetAdministrationShellManager;
import org.eclipse.basyx.aas.metamodel.map.AssetAdministrationShell;
import org.eclipse.basyx.aas.metamodel.map.descriptor.AASDescriptor;
import org.eclipse.basyx.aas.metamodel.map.descriptor.SubmodelDescriptor;
import org.eclipse.basyx.aas.registration.api.IAASRegistry;
import org.eclipse.basyx.aas.registration.proxy.AASRegistryProxy;
import org.eclipse.basyx.submodel.metamodel.api.identifier.IIdentifier;
import org.eclipse.basyx.vab.exception.provider.ProviderException;
import org.eclipse.basyx.vab.exception.provider.ResourceNotFoundException;
import org.eclipse.basyx.vab.protocol.api.IConnectorFactory;

public class BaSyxRegistry
implements Registry {
    private Endpoint endpoint;
    private IAASRegistry registry;
    private ConnectedAssetAdministrationShellManager manager;

    public BaSyxRegistry(Endpoint endpoint, IConnectorFactory connectorFactory) throws IOException {
        this.endpoint = endpoint;
        try {
            this.registry = new AASRegistryProxy(this.endpoint.toUri());
            this.manager = new ConnectedAssetAdministrationShellManager(this.registry, connectorFactory);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public Aas retrieveAas(String identifier) throws IOException {
        return this.retrieveAas(identifier, true);
    }

    public Aas retrieveAas(String identifier, boolean populate) throws IOException {
        BaSyxConnectedAas result = null;
        IIdentifier id = null;
        if (null != identifier) {
            if (identifier.startsWith(Schema.HTTP.toUri()) || identifier.startsWith(Schema.HTTPS.toUri())) {
                List descs = this.registry.lookupAll();
                for (int d = 0; null == id && d < descs.size(); ++d) {
                    if (!identifier.equals(((AASDescriptor)descs.get(d)).getFirstEndpoint())) continue;
                    id = ((AASDescriptor)descs.get(d)).getIdentifier();
                }
            } else {
                id = Tools.translateIdentifier(identifier, "");
            }
            if (null != id) {
                result = this.obtainAas(id, populate);
            }
        }
        return result;
    }

    public List<String> getAasIdShorts() {
        return this.getStrings(d -> d.getIdShort());
    }

    public List<String> getAasIdentifiers() {
        return this.getStrings(d -> Tools.translateIdentifier(d.getIdentifier()));
    }

    private List<String> getStrings(Function<AASDescriptor, String> func) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            List desc = this.registry.lookupAll();
            for (AASDescriptor d : desc) {
                String tmp = func.apply(d);
                if (tmp == null) continue;
                result.add(tmp);
            }
        }
        catch (ProviderException e) {
            LoggerFactory.getLogger(this.getClass()).error("Cannot obtain AAS descriptor: " + e.getMessage());
        }
        return result;
    }

    private BaSyxConnectedAas obtainAas(IIdentifier aasId, boolean populate) throws IOException {
        try {
            return new BaSyxConnectedAas(this.manager.retrieveAAS(aasId), populate);
        }
        catch (ProviderException e) {
            throw new IOException(e);
        }
    }

    public Submodel retrieveSubmodel(String aasIdentifier, String submodelIdentifier) throws IOException {
        try {
            IIdentifier aasId = Tools.translateIdentifier(aasIdentifier, "");
            IIdentifier submodelId = Tools.translateIdentifier(submodelIdentifier, "");
            return new BaSyxISubmodel(this.obtainAas(aasId, true), this.manager.retrieveSubmodel(aasId, submodelId), true);
        }
        catch (ProviderException e) {
            throw new IOException(e);
        }
    }

    public void createAas(Aas aas, String endpointURL) {
        if (!(aas instanceof BaSyxAas)) {
            throw new IllegalArgumentException("The aas must be created by the AasFactory.");
        }
        BaSyxAas a = (BaSyxAas)aas;
        a.registerRegistry(this);
        try {
            this.manager.createAAS((AssetAdministrationShell)a.getAas(), endpointURL);
        }
        catch (ProviderException e) {
            LoggerFactory.getLogger(this.getClass()).error("Cannot create AAS: " + e.getMessage());
        }
    }

    public void createSubmodel(Aas aas, Submodel submodel) {
        if (!(aas instanceof BaSyxAas)) {
            throw new IllegalArgumentException("The aas must be created by the AasFactory.");
        }
        if (!(submodel instanceof BaSyxSubmodel)) {
            throw new IllegalArgumentException("The submodel must be created by the AasFactory.");
        }
        IIdentifier aasIdentifier = ((AssetAdministrationShell)((BaSyxAas)aas).getAas()).getIdentification();
        try {
            this.manager.createSubmodel(aasIdentifier, (org.eclipse.basyx.submodel.metamodel.map.Submodel)((BaSyxSubmodel)submodel).getSubmodel());
        }
        catch (ProviderException e) {
            LoggerFactory.getLogger(this.getClass()).error("Cannot create submodel: " + e.getMessage());
        }
    }

    public void register(Aas aas, Submodel submodel, String endpointUrl) {
        if (!(aas instanceof BaSyxAas)) {
            throw new IllegalArgumentException("The aas must be created by the AasFactory.");
        }
        if (!(submodel instanceof BaSyxSubmodel)) {
            throw new IllegalArgumentException("The submodel must be created by the AasFactory.");
        }
        if (null == endpointUrl) {
            endpointUrl = AbstractSubmodel.getSubmodelEndpoint((ServerAddress)this.endpoint, aas, submodel);
        }
        IIdentifier aasIdentifier = ((AssetAdministrationShell)((BaSyxAas)aas).getAas()).getIdentification();
        try {
            this.registry.register(aasIdentifier, new SubmodelDescriptor(submodel.getIdShort(), ((org.eclipse.basyx.submodel.metamodel.map.Submodel)((BaSyxSubmodel)submodel).getSubmodel()).getIdentification(), endpointUrl));
        }
        catch (ProviderException e) {
            LoggerFactory.getLogger(this.getClass()).error("Cannot register submodel: " + e.getMessage());
        }
    }

    public String getEndpoint(String aasIdShort) {
        String result = null;
        try {
            for (AASDescriptor desc : this.registry.lookupAll()) {
                if (!desc.getIdShort().equals(aasIdShort)) continue;
                result = desc.getFirstEndpoint();
            }
        }
        catch (ResourceNotFoundException resourceNotFoundException) {
            // empty catch block
        }
        return result;
    }

    public String getEndpoint(Aas aas) {
        String result = null;
        if (aas instanceof AbstractAas) {
            try {
                AASDescriptor desc = this.registry.lookupAAS(((AbstractAas)aas).getAas().getIdentification());
                result = desc.getFirstEndpoint();
            }
            catch (ProviderException providerException) {
                // empty catch block
            }
        }
        return result;
    }

    public String getEndpoint(Aas aas, Submodel submodel) {
        String result = null;
        if (aas instanceof BaSyxAas && submodel instanceof BaSyxSubmodel) {
            try {
                SubmodelDescriptor desc = this.registry.lookupSubmodel(((AssetAdministrationShell)((BaSyxAas)aas).getAas()).getIdentification(), ((org.eclipse.basyx.submodel.metamodel.map.Submodel)((BaSyxSubmodel)submodel).getSubmodel()).getIdentification());
                result = desc.getFirstEndpoint();
            }
            catch (ProviderException providerException) {
                // empty catch block
            }
        }
        return result;
    }

    IAASRegistry getRegistry() {
        return this.registry;
    }
}

