/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.components.registry.mqtt;

import org.eclipse.basyx.aas.registration.api.IAASRegistry;
import org.eclipse.basyx.aas.registration.observing.ObservableAASRegistryService;
import org.eclipse.basyx.components.configuration.BaSyxMqttConfiguration;
import org.eclipse.basyx.components.configuration.MqttPersistence;
import org.eclipse.basyx.extensions.aas.registration.mqtt.MqttAASRegistryServiceObserver;
import org.eclipse.basyx.submodel.observer.IObserver;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;
import org.eclipse.paho.client.mqttv3.persist.MqttDefaultFilePersistence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttRegistryFactory {
    private static Logger logger = LoggerFactory.getLogger(MqttRegistryFactory.class);

    public IAASRegistry create(IAASRegistry registry, BaSyxMqttConfiguration mqttConfig) {
        return MqttRegistryFactory.wrapRegistryInMqttObserver(registry, mqttConfig);
    }

    private static IAASRegistry wrapRegistryInMqttObserver(IAASRegistry registry, BaSyxMqttConfiguration mqttConfig) {
        ObservableAASRegistryService observedAPI = new ObservableAASRegistryService(registry);
        MqttRegistryFactory.addAASRegistryServiceObserver(observedAPI, mqttConfig);
        return observedAPI;
    }

    protected static void addAASRegistryServiceObserver(ObservableAASRegistryService observedAPI, BaSyxMqttConfiguration mqttConfig) {
        String brokerEndpoint = mqttConfig.getServer();
        MqttClientPersistence mqttPersistence = MqttRegistryFactory.getMqttPersistenceFromConfig(mqttConfig);
        try {
            MqttAASRegistryServiceObserver mqttObserver = new MqttAASRegistryServiceObserver(brokerEndpoint, mqttConfig.getClientId(), mqttConfig.getUser(), mqttConfig.getPass().toCharArray(), mqttPersistence);
            observedAPI.addObserver((IObserver)mqttObserver);
        }
        catch (MqttException e) {
            logger.error("Could not establish MQTT connection for MqttAASRegistry", (Throwable)e);
        }
    }

    protected static MqttClientPersistence getMqttPersistenceFromConfig(BaSyxMqttConfiguration config) {
        String persistenceFilePath = config.getPersistencePath();
        MqttPersistence persistenceType = config.getPersistenceType();
        if (MqttRegistryFactory.isFilePersistenceType(persistenceType)) {
            return MqttRegistryFactory.createMqttFilePersistence(persistenceFilePath);
        }
        return new MemoryPersistence();
    }

    private static MqttClientPersistence createMqttFilePersistence(String persistenceFilePath) {
        if (!MqttRegistryFactory.isFilePathSet(persistenceFilePath)) {
            return new MqttDefaultFilePersistence();
        }
        return new MqttDefaultFilePersistence(persistenceFilePath);
    }

    private static boolean isFilePathSet(String persistenceFilePath) {
        return persistenceFilePath != null && !persistenceFilePath.isEmpty();
    }

    private static boolean isFilePersistenceType(MqttPersistence persistenceType) {
        return persistenceType == MqttPersistence.FILE;
    }
}

