/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store.jdbc;

import org.apache.qpid.server.model.ManagedAttribute;
import org.apache.qpid.server.model.ManagedContextDefault;
import org.apache.qpid.server.model.SystemConfig;
import org.apache.qpid.server.store.jdbc.JDBCSettings;
import org.apache.qpid.server.store.preferences.PreferenceStoreAttributes;
import org.apache.qpid.server.store.preferences.PreferenceStoreProvider;

public interface JDBCSystemConfig<X extends JDBCSystemConfig<X>>
extends SystemConfig<X>,
JDBCSettings,
PreferenceStoreProvider {
    @ManagedContextDefault(name="systemConfig.tableNamePrefix")
    public static final String DEFAULT_SYSTEM_CONFIG_TABLE_NAME_PREFIX = "";

    @Override
    @ManagedAttribute(mandatory=true, defaultValue="${systemConfig.connectionUrl}")
    public String getConnectionUrl();

    @Override
    @ManagedAttribute(defaultValue="${systemConfig.connectionPoolType}")
    public String getConnectionPoolType();

    @Override
    @ManagedAttribute(defaultValue="${systemConfig.username}")
    public String getUsername();

    @Override
    @ManagedAttribute(secure=true, defaultValue="${systemConfig.password}")
    public String getPassword();

    @ManagedAttribute(description="Configuration for the preference store, e.g. type, path, etc.", defaultValue="{\"type\": \"Provided\"}")
    public PreferenceStoreAttributes getPreferenceStoreAttributes();

    @Override
    @ManagedAttribute(secure=true, description="Optional database table prefix so multiple SystemConfigs can share the same database", defaultValue="${systemConfig.tableNamePrefix}", validValuePattern="[a-zA-Z_0-9]*")
    public String getTableNamePrefix();
}

