/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.iip_aas;

import de.iip_ecosphere.platform.support.LifecycleDescriptor;
import de.iip_ecosphere.platform.support.OsUtils;
import de.iip_ecosphere.platform.support.Server;
import de.iip_ecosphere.platform.support.TimeUtils;
import de.iip_ecosphere.platform.support.aas.AasFactory;
import de.iip_ecosphere.platform.support.aas.ProtocolServerBuilder;
import de.iip_ecosphere.platform.support.aas.SetupSpec;
import de.iip_ecosphere.platform.support.iip_aas.AasContributor;
import de.iip_ecosphere.platform.support.iip_aas.AasPartRegistry;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.support.setup.CmdLine;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class AbstractAasLifecycleDescriptor
implements LifecycleDescriptor {
    public static final String PARAM_IIP_PORT = "iip.port";
    private static final int AAS_HEARTBEAT_PERIOD = 5000;
    private static Server implServer;
    private static ProtocolServerBuilder implServerBuilder;
    private static boolean waitForIipAas;
    private String name;
    private Supplier<AasPartRegistry.AasSetup> setupSupplier;
    private Server aasServer;
    private Timer timer;

    protected AbstractAasLifecycleDescriptor(String name, Supplier<AasPartRegistry.AasSetup> setupSupplier) {
        this.name = name;
        this.setupSupplier = setupSupplier;
    }

    public static boolean setWaitForIipAas(boolean wait) {
        boolean old = waitForIipAas;
        waitForIipAas = wait;
        return old;
    }

    public AasPartRegistry.AasSetup getAasSetup() {
        return this.setupSupplier.get();
    }

    protected String getOverridePortArg() {
        return null;
    }

    private static int getPort(String[] args, String arg, int init) {
        int port = init;
        if (null != arg && port < 0 && (port = CmdLine.getIntArg((String[])args, (String)arg, (int)-1)) < 0 && OsUtils.getEnv((String)arg) != null) {
            try {
                port = Integer.parseInt(OsUtils.getEnv((String)arg));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return port;
    }

    protected Predicate<AasContributor> getContributorFilter() {
        return c -> true;
    }

    public void startup(final String[] args) {
        LoggerFactory.getLogger(this.getClass()).info("System environment: {}", System.getenv());
        this.deploy(args, this.getContributorFilter());
        if (null == this.timer && this.enableAasHeartbeat()) {
            final AasFactory factory = AasFactory.getInstance();
            final AasPartRegistry.AasSetup setup = AasPartRegistry.getSetup();
            final String serverUrl = setup.getAasRepositoryEndpoint().toServerUri();
            try {
                this.timer = new Timer(true);
                this.timer.schedule(new TimerTask(){
                    private boolean offline = false;

                    @Override
                    public void run() {
                        boolean hasConn = factory.isAvailable((SetupSpec)setup, SetupSpec.AasComponent.AAS_REPOSITORY);
                        if (this.offline) {
                            if (hasConn) {
                                this.offline = false;
                                LoggerFactory.getLogger(this.getClass()).warn("AAS repository {} back. Re-deploying AAS.", (Object)serverUrl);
                                AbstractAasLifecycleDescriptor.this.deploy(args, c -> !c.exists() && AbstractAasLifecycleDescriptor.this.getContributorFilter().test((AasContributor)c));
                                LoggerFactory.getLogger(this.getClass()).warn("AAS repository {} back. AAS re-deployed.", (Object)serverUrl);
                            }
                        } else if (!hasConn) {
                            LoggerFactory.getLogger(this.getClass()).warn("AAS repository {} offline", (Object)serverUrl);
                            this.offline = true;
                        }
                    }
                }, 5000L, 5000L);
            }
            catch (IllegalArgumentException e) {
                LoggerFactory.getLogger(this.getClass()).warn("Cannot heartbeat for AAS repository. URL {} invalid: {}", (Object)serverUrl, (Object)e.getMessage());
            }
        }
    }

    private void deploy(String[] args, Predicate<AasContributor> contributorFilter) {
        int port = AbstractAasLifecycleDescriptor.getPort(args, PARAM_IIP_PORT, AbstractAasLifecycleDescriptor.getPort(args, this.getOverridePortArg(), -1));
        if (port > 0) {
            this.setupSupplier.get().getImplementation().setPort(port);
            LoggerFactory.getLogger(this.getClass()).info("Using port " + port + " for the AAS implementation server.");
        }
        if (AasFactory.isFullInstance()) {
            AasPartRegistry.AasSetup setup = this.getAasSetup();
            AasPartRegistry.setAasSetup(setup);
            this.waitForAasServer();
            AasPartRegistry.AasBuildResult res = AasPartRegistry.build(contributorFilter, null == implServer, implServerBuilder);
            if (null == implServer) {
                implServerBuilder = res.getProtocolServerBuilder();
                implServer = res.getProtocolServer();
            }
            boolean success = true;
            if (AasPartRegistry.AasMode.REGISTER == setup.getMode()) {
                try {
                    this.aasServer = AasPartRegistry.register(res.getAas(), setup.getRegistryEndpoint(), new String[0]);
                    this.aasServer.start();
                }
                catch (IOException e) {
                    LoggerFactory.getLogger(this.getClass()).error("Cannot register AAS " + this.name + " with " + setup.getRegistryEndpoint().toUri() + ":" + e.getMessage());
                    success = false;
                }
            } else {
                try {
                    AasPartRegistry.remoteDeploy(res.getAas());
                }
                catch (IOException e) {
                    LoggerFactory.getLogger(this.getClass()).error("Cannot deploy AAS " + this.name + ": " + e.getMessage());
                    success = false;
                }
            }
            if (success) {
                AasPartRegistry.setAasSupplier(() -> res.getAas());
            }
        } else {
            LoggerFactory.getLogger(this.getClass()).warn("No full AAS implementation registered. Cannot build up {} AAS. Please add an appropriate dependency.", (Object)this.name);
        }
    }

    protected boolean enableAasHeartbeat() {
        return true;
    }

    protected void waitForAasServer() {
        AasFactory factory = AasFactory.getInstance();
        AasPartRegistry.AasSetup setup = AasPartRegistry.getSetup();
        String regAdr = setup.getRegistryEndpoint().toServerUri();
        String serverAdr = setup.getServerEndpoint().toServerUri();
        int startupTimeout = setup.getAasStartupTimeout();
        try {
            LoggerFactory.getLogger(this.getClass()).info("Probing AAS registry {} and repository {} for {} ms", new Object[]{regAdr, serverAdr, startupTimeout});
            if (!TimeUtils.waitFor(() -> !factory.isAvailable((SetupSpec)setup, SetupSpec.AasComponent.AAS_REGISTRY) || !factory.isAvailable((SetupSpec)setup, SetupSpec.AasComponent.AAS_REPOSITORY) || !this.iipAasExists(), (int)startupTimeout, (int)500)) {
                LoggerFactory.getLogger(this.getClass()).error("No AAS registry/server reached within {} ms", (Object)startupTimeout);
            } else {
                LoggerFactory.getLogger(this.getClass()).info("AAS registry found at {} and server at {}", (Object)regAdr, (Object)serverAdr);
            }
        }
        catch (IllegalArgumentException e) {
            LoggerFactory.getLogger(this.getClass()).warn("Cannot wait for AAS registry/server. AAS registry {} or server {} URL invalid: {}", new Object[]{regAdr, serverAdr, e.getMessage()});
        }
    }

    protected boolean iipAasExists() {
        boolean exists;
        if (waitForIipAas) {
            try {
                exists = null != AasPartRegistry.retrieveIipAas();
            }
            catch (IOException e) {
                exists = false;
            }
        } else {
            exists = true;
        }
        return exists;
    }

    public void shutdown() {
        if (null != this.timer) {
            this.timer.cancel();
        }
        if (null != implServer) {
            implServer.stop(true);
        }
        if (null != this.aasServer) {
            implServer.stop(true);
        }
    }

    public Thread getShutdownHook() {
        return null;
    }

    public int priority() {
        return 100;
    }

    static {
        waitForIipAas = true;
    }
}

