/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.query.engine.parsing.factory;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.qpid.server.query.engine.exception.QueryParsingException;
import org.apache.qpid.server.query.engine.parsing.expression.ExpressionNode;
import org.apache.qpid.server.query.engine.parsing.expression.function.aggregation.AvgExpression;
import org.apache.qpid.server.query.engine.parsing.expression.function.aggregation.CountExpression;
import org.apache.qpid.server.query.engine.parsing.expression.function.aggregation.MaxExpression;
import org.apache.qpid.server.query.engine.parsing.expression.function.aggregation.MinExpression;
import org.apache.qpid.server.query.engine.parsing.expression.function.aggregation.SumExpression;
import org.apache.qpid.server.query.engine.parsing.expression.function.datetime.CurrentTimestampExpression;
import org.apache.qpid.server.query.engine.parsing.expression.function.datetime.DateAddExpression;
import org.apache.qpid.server.query.engine.parsing.expression.function.datetime.DateDiffExpression;
import org.apache.qpid.server.query.engine.parsing.expression.function.datetime.DateExpression;
import org.apache.qpid.server.query.engine.parsing.expression.function.datetime.ExtractExpression;
import org.apache.qpid.server.query.engine.parsing.expression.function.nulls.CoalesceExpression;
import org.apache.qpid.server.query.engine.parsing.expression.function.numeric.AbsExpression;
import org.apache.qpid.server.query.engine.parsing.expression.function.numeric.RoundExpression;
import org.apache.qpid.server.query.engine.parsing.expression.function.numeric.TruncExpression;
import org.apache.qpid.server.query.engine.parsing.expression.function.string.ConcatExpression;
import org.apache.qpid.server.query.engine.parsing.expression.function.string.LeftTrimExpression;
import org.apache.qpid.server.query.engine.parsing.expression.function.string.LengthExpression;
import org.apache.qpid.server.query.engine.parsing.expression.function.string.LowerExpression;
import org.apache.qpid.server.query.engine.parsing.expression.function.string.PositionExpression;
import org.apache.qpid.server.query.engine.parsing.expression.function.string.ReplaceExpression;
import org.apache.qpid.server.query.engine.parsing.expression.function.string.RightTrimExpression;
import org.apache.qpid.server.query.engine.parsing.expression.function.string.SubstringExpression;
import org.apache.qpid.server.query.engine.parsing.expression.function.string.TrimExpression;
import org.apache.qpid.server.query.engine.parsing.expression.function.string.UpperExpression;

public final class FunctionExpressionFactory {
    private static final List<String> FUNCTION_NAMES = Arrays.stream(Functions.values()).map(Enum::name).collect(Collectors.toList());
    private static final Map<Functions, BiFunction<?, ?, ?>> FUNCTIONS = ImmutableMap.builder().put((Object)Functions.ABS, FunctionExpressionFactory.absExpression()).put((Object)Functions.AVG, FunctionExpressionFactory.avgExpression()).put((Object)Functions.COALESCE, FunctionExpressionFactory.coalesceExpression()).put((Object)Functions.CONCAT, FunctionExpressionFactory.concatExpression()).put((Object)Functions.COUNT, FunctionExpressionFactory.countExpression()).put((Object)Functions.CURRENT_TIMESTAMP, FunctionExpressionFactory.currentTimestampExpression()).put((Object)Functions.DATE, FunctionExpressionFactory.dateExpression()).put((Object)Functions.DATEADD, FunctionExpressionFactory.dateAddExpression()).put((Object)Functions.DATEDIFF, FunctionExpressionFactory.dateDiffExpression()).put((Object)Functions.EXTRACT, FunctionExpressionFactory.extractExpression()).put((Object)Functions.LEN, FunctionExpressionFactory.lenExpression()).put((Object)Functions.LENGTH, FunctionExpressionFactory.lenExpression()).put((Object)Functions.LOWER, FunctionExpressionFactory.lowerExpression()).put((Object)Functions.LTRIM, FunctionExpressionFactory.ltrim()).put((Object)Functions.MAX, FunctionExpressionFactory.maxExpression()).put((Object)Functions.MIN, FunctionExpressionFactory.minExpression()).put((Object)Functions.POSITION, FunctionExpressionFactory.positionExpression()).put((Object)Functions.REPLACE, FunctionExpressionFactory.replaceExpression()).put((Object)Functions.ROUND, FunctionExpressionFactory.roundExpression()).put((Object)Functions.RTRIM, FunctionExpressionFactory.rtrimExpression()).put((Object)Functions.SUBSTR, FunctionExpressionFactory.substringExpression()).put((Object)Functions.SUBSTRING, FunctionExpressionFactory.substringExpression()).put((Object)Functions.SUM, FunctionExpressionFactory.sumExpression()).put((Object)Functions.TRIM, FunctionExpressionFactory.trimExpression()).put((Object)Functions.TRUNC, FunctionExpressionFactory.truncExpression()).put((Object)Functions.UPPER, FunctionExpressionFactory.upperExpression()).build();

    private FunctionExpressionFactory() {
    }

    private static <T> BiFunction<String, List<ExpressionNode<T, ?>>, AbsExpression<T>> absExpression() {
        return AbsExpression::new;
    }

    private static <T> BiFunction<String, List<ExpressionNode<T, ?>>, AvgExpression<T>> avgExpression() {
        return AvgExpression::new;
    }

    private static <T, R> BiFunction<String, List<ExpressionNode<T, ?>>, CoalesceExpression<T, R>> coalesceExpression() {
        return CoalesceExpression::new;
    }

    private static <T, R> BiFunction<String, List<ExpressionNode<T, ?>>, ConcatExpression<T, R>> concatExpression() {
        return ConcatExpression::new;
    }

    private static <T> BiFunction<String, List<ExpressionNode<T, ?>>, CountExpression<T>> countExpression() {
        return CountExpression::new;
    }

    private static <T> BiFunction<String, List<ExpressionNode<T, ?>>, CurrentTimestampExpression<T>> currentTimestampExpression() {
        return CurrentTimestampExpression::new;
    }

    private static <T, R> BiFunction<String, List<ExpressionNode<T, ?>>, DateExpression<T, R>> dateExpression() {
        return DateExpression::new;
    }

    private static <T, R> BiFunction<String, List<ExpressionNode<T, ?>>, DateAddExpression<T, R>> dateAddExpression() {
        return DateAddExpression::new;
    }

    private static <T, R> BiFunction<String, List<ExpressionNode<T, ?>>, DateDiffExpression<T, R>> dateDiffExpression() {
        return DateDiffExpression::new;
    }

    private static <T, R> BiFunction<String, List<ExpressionNode<T, ?>>, ExtractExpression<T, R>> extractExpression() {
        return ExtractExpression::new;
    }

    private static <T, R> BiFunction<String, List<ExpressionNode<T, ?>>, LengthExpression<T, R>> lenExpression() {
        return LengthExpression::new;
    }

    private static <T, R> BiFunction<String, List<ExpressionNode<T, ?>>, LowerExpression<T, R>> lowerExpression() {
        return LowerExpression::new;
    }

    private static <T, R> BiFunction<String, List<ExpressionNode<T, ?>>, LeftTrimExpression<T, R>> ltrim() {
        return LeftTrimExpression::new;
    }

    private static <T, R extends Comparable<R>> BiFunction<String, List<ExpressionNode<T, ?>>, MaxExpression<T, R>> maxExpression() {
        return MaxExpression::new;
    }

    private static <T, R> BiFunction<String, List<ExpressionNode<T, ?>>, MinExpression<T, R>> minExpression() {
        return MinExpression::new;
    }

    private static <T, R> BiFunction<String, List<ExpressionNode<T, ?>>, PositionExpression<T, R>> positionExpression() {
        return PositionExpression::new;
    }

    private static <T, R> BiFunction<String, List<ExpressionNode<T, ?>>, ReplaceExpression<T, R>> replaceExpression() {
        return ReplaceExpression::new;
    }

    private static <T> BiFunction<String, List<ExpressionNode<T, ?>>, RoundExpression<T>> roundExpression() {
        return RoundExpression::new;
    }

    private static <T, R> BiFunction<String, List<ExpressionNode<T, ?>>, RightTrimExpression<T, R>> rtrimExpression() {
        return RightTrimExpression::new;
    }

    private static <T, R> BiFunction<String, List<ExpressionNode<T, ?>>, SubstringExpression<T, R>> substringExpression() {
        return SubstringExpression::new;
    }

    private static <T> BiFunction<String, List<ExpressionNode<T, ?>>, SumExpression<T>> sumExpression() {
        return SumExpression::new;
    }

    private static <T, R> BiFunction<String, List<ExpressionNode<T, ?>>, TrimExpression<T, R>> trimExpression() {
        return TrimExpression::new;
    }

    private static <T> BiFunction<String, List<ExpressionNode<T, ?>>, TruncExpression<T>> truncExpression() {
        return TruncExpression::new;
    }

    private static <T, R> BiFunction<String, List<ExpressionNode<T, ?>>, UpperExpression<T, R>> upperExpression() {
        return UpperExpression::new;
    }

    private static <T, R> BiFunction<String, List<ExpressionNode<T, ?>>, ExpressionNode<T, R>> getFunction(Functions key) {
        return FUNCTIONS.get((Object)key);
    }

    public static <T, R> ExpressionNode<T, R> createFunction(String alias, String name, List<ExpressionNode<T, ?>> args) {
        Objects.requireNonNull(name, "Function name should be not null");
        Objects.requireNonNull(args, "Function argument list should be not null");
        String normalizedName = name.toUpperCase(Locale.US);
        if (!FUNCTION_NAMES.contains(normalizedName)) {
            throw QueryParsingException.of("Function '%s' not found", name);
        }
        Functions function = Functions.valueOf(normalizedName);
        return FunctionExpressionFactory.getFunction(function).apply(alias, args);
    }

    private static enum Functions {
        ABS,
        AVG,
        COALESCE,
        CONCAT,
        COUNT,
        CURRENT_TIMESTAMP,
        DATE,
        DATEADD,
        DATEDIFF,
        EXTRACT,
        LEN,
        LENGTH,
        LOWER,
        LTRIM,
        MAX,
        MIN,
        POSITION,
        REPLACE,
        ROUND,
        RTRIM,
        SUBSTR,
        SUBSTRING,
        SUM,
        TRIM,
        TRUNC,
        UPPER;

    }
}

