/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.core.execution.locks;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import jetbrains.exodus.core.execution.locks.Latch;
import jetbrains.exodus.core.execution.locks.ReleaseLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DebugLatch
extends ReleaseLatch {
    private static final Logger log = LoggerFactory.getLogger(Latch.class);
    private static final DateFormat df = new SimpleDateFormat("dd MMM yyyy kk:mm:ss,SSS");
    private Date acquireTime = null;
    private StackTraceElement[] acquireTrace = null;

    DebugLatch() {
    }

    @Override
    public synchronized void acquire() throws InterruptedException {
        while (this.owner != null) {
            this.logOwner();
            this.wait();
        }
        this.owner = Thread.currentThread();
        this.gatherOwnerInfo();
    }

    @Override
    public synchronized boolean acquire(long timeout) throws InterruptedException {
        if (this.owner != null) {
            this.logOwner();
            this.wait(timeout);
            if (this.owner != null) {
                return false;
            }
        }
        this.owner = Thread.currentThread();
        this.gatherOwnerInfo();
        return true;
    }

    @Override
    public synchronized boolean tryAcquire() {
        if (this.owner != null) {
            this.logOwner();
            return false;
        }
        this.owner = Thread.currentThread();
        this.gatherOwnerInfo();
        return true;
    }

    @Override
    public synchronized void release() {
        this.clearOwnerInfo();
        this.owner = null;
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logOwner() {
        try {
            log.debug("-------------------------------------------------------------");
            log.debug("DebugLatch is closed at [" + df.format(this.acquireTime) + "]. Will wait for latch owner [" + this.owner.getName() + ']');
            log.debug("Owner stack trace:");
            for (StackTraceElement e : this.acquireTrace) {
                log.debug(e.toString());
            }
        }
        catch (Throwable throwable) {
        }
        finally {
            log.debug("-------------------------------------------------------------");
        }
    }

    private void gatherOwnerInfo() {
        this.acquireTime = new Date();
        this.acquireTrace = new Throwable().getStackTrace();
    }

    private void clearOwnerInfo() {
        this.acquireTime = null;
        this.acquireTrace = null;
    }
}

