/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.iip_aas;

import de.iip_ecosphere.platform.support.LifecycleHandler;
import de.iip_ecosphere.platform.support.aas.AasUtils;
import de.iip_ecosphere.platform.support.iip_aas.IdProvider;
import de.iip_ecosphere.platform.support.iip_aas.IdProviderDescriptor;
import de.iip_ecosphere.platform.support.iip_aas.MacIdProvider;
import de.iip_ecosphere.platform.support.jsl.ServiceLoaderUtils;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.support.setup.CmdLine;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.util.Optional;

public class Id {
    private static final String JVM_NAME;
    private static final String JVM_NAME_AAS;
    private static final String DEVICE_ID;
    private static final String DEVICE_ID_AAS;
    private static final String DEVICE_NAME;
    private static final String DEVICE_NAME_AAS;
    private static final String DEVICE_IP;
    private static final String DEVICE_IP_AAS;

    public static final String getEnvId() {
        return JVM_NAME;
    }

    public static final String getEnvIdAas() {
        return JVM_NAME_AAS;
    }

    public static final String getDeviceId() {
        return DEVICE_ID;
    }

    public static final String getDeviceIdAas() {
        return DEVICE_ID_AAS;
    }

    public static final String getDeviceName() {
        return DEVICE_NAME;
    }

    public static final String getDeviceNameAas() {
        return DEVICE_NAME_AAS;
    }

    public static final String getDeviceIp() {
        return DEVICE_IP;
    }

    public static final String getDeviceIpAas() {
        return DEVICE_IP_AAS;
    }

    static {
        String overrideId;
        JVM_NAME = ManagementFactory.getRuntimeMXBean().getName();
        JVM_NAME_AAS = AasUtils.fixId((String)JVM_NAME);
        Optional desc = ServiceLoaderUtils.findFirst(IdProviderDescriptor.class);
        IdProviderDescriptor provDesc = desc.isPresent() ? (IdProviderDescriptor)desc.get() : new MacIdProvider.MacIdProviderDescriptor();
        IdProvider provider = provDesc.createProvider();
        String deviceId = null;
        String hostName = null;
        String ip = null;
        try {
            InetAddress localHost = InetAddress.getLocalHost();
            hostName = localHost.getHostName();
            ip = localHost.getHostAddress();
        }
        catch (IOException e) {
            LoggerFactory.getLogger(Id.class).error("Obtaining device ID: " + e.getMessage());
            hostName = JVM_NAME;
            ip = "";
        }
        String providerName = "?";
        if (provider.allowsConsoleOverride() && null != LifecycleHandler.getCmdArgs() && null != (overrideId = CmdLine.getArg((String[])LifecycleHandler.getCmdArgs(), (String)"iip.id", null))) {
            deviceId = overrideId;
            providerName = "command line";
        }
        if (null == deviceId) {
            deviceId = provider.provideId();
            providerName = provider.getClass().getName();
        }
        if (null == deviceId) {
            deviceId = JVM_NAME;
            providerName = "fallback";
        }
        LoggerFactory.getLogger(Id.class).info("USING id " + deviceId + " from " + providerName);
        DEVICE_ID = deviceId;
        DEVICE_ID_AAS = AasUtils.fixId((String)deviceId);
        DEVICE_NAME = hostName;
        DEVICE_NAME_AAS = AasUtils.fixId((String)hostName);
        DEVICE_IP = ip;
        DEVICE_IP_AAS = AasUtils.fixId((String)ip);
    }
}

