/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.access.config;

import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.security.auth.Subject;
import org.apache.qpid.server.security.access.config.AclRulePredicatesBuilder;
import org.apache.qpid.server.security.access.config.LegacyOperation;
import org.apache.qpid.server.security.access.config.ObjectProperties;
import org.apache.qpid.server.security.access.config.Property;
import org.apache.qpid.server.security.access.config.RulePredicate;
import org.apache.qpid.server.security.access.firewall.FirewallRuleFactory;

public final class AclRulePredicates
extends AbstractMap<Property, Set<Object>>
implements RulePredicate {
    public static final String SEPARATOR = ",";
    private static final Set<Property> JOIN_PROPERTIES = EnumSet.of(Property.ATTRIBUTES, Property.FROM_HOSTNAME, Property.FROM_NETWORK);
    private final Map<Property, Set<Object>> _properties;
    private final RulePredicate _rulePredicate;

    AclRulePredicates() {
        this._properties = Collections.emptyMap();
        this._rulePredicate = RulePredicate.any();
    }

    AclRulePredicates(AclRulePredicatesBuilder builder) {
        this._properties = Objects.requireNonNull(builder.newProperties());
        this._rulePredicate = Objects.requireNonNull(builder.newRulePredicate());
    }

    AclRulePredicates(FirewallRuleFactory factory, AclRulePredicatesBuilder builder) {
        this._properties = Objects.requireNonNull(builder.newProperties());
        this._rulePredicate = Objects.requireNonNull(builder.newRulePredicate(factory));
    }

    public Map<Property, Object> getParsedProperties() {
        EnumMap<Property, Object> parsed = new EnumMap<Property, Object>(Property.class);
        for (Map.Entry<Property, Set<Object>> entry : this._properties.entrySet()) {
            Set<Object> values = entry.getValue();
            if (values.size() == 1) {
                parsed.put(entry.getKey(), (Object)Iterables.getOnlyElement(values).toString());
                continue;
            }
            parsed.put(entry.getKey(), this.collect(entry.getKey(), values));
        }
        return parsed;
    }

    private Object collect(Property property, Set<Object> values) {
        if (JOIN_PROPERTIES.contains((Object)property)) {
            return values.stream().map(Object::toString).sorted().collect(Collectors.joining(SEPARATOR));
        }
        return values.stream().map(Object::toString).sorted().collect(Collectors.toList());
    }

    @Override
    public boolean matches(LegacyOperation operation, ObjectProperties objectProperties, Subject subject) {
        return this._rulePredicate.matches(operation, objectProperties, subject);
    }

    @Override
    public RulePredicate and(RulePredicate other) {
        return this._rulePredicate.and(other);
    }

    public RulePredicate asSinglePredicate() {
        return this._rulePredicate;
    }

    @Override
    public Set<Map.Entry<Property, Set<Object>>> entrySet() {
        return Collections.unmodifiableSet(this._properties.entrySet());
    }

    @Override
    public int size() {
        return this._properties.size();
    }

    @Override
    public boolean isEmpty() {
        return this._properties.isEmpty();
    }

    @Override
    public Set<Object> get(Object key) {
        return this._properties.getOrDefault(key, Collections.emptySet());
    }

    @Override
    public boolean containsValue(Object value) {
        return this._properties.containsValue(value);
    }

    @Override
    public boolean containsKey(Object key) {
        return this._properties.containsKey(key);
    }

    @Override
    public Set<Property> keySet() {
        return Collections.unmodifiableSet(this._properties.keySet());
    }

    @Override
    public Collection<Set<Object>> values() {
        return Collections.unmodifiableCollection(this._properties.values());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("AclRulePredicates[");
        Joiner joiner = Joiner.on((String)SEPARATOR);
        joiner.withKeyValueSeparator("=").appendTo(sb, this.getParsedProperties());
        sb.append("]");
        return sb.toString();
    }
}

