/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq;

import com.hivemq.bootstrap.HiveMQNettyBootstrap;
import com.hivemq.bootstrap.StartupListenerVerifier;
import com.hivemq.embedded.EmbeddedExtension;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.extension.sdk.api.services.admin.AdminService;
import com.hivemq.extensions.ExtensionBootstrap;
import com.hivemq.extensions.services.admin.AdminServiceImpl;
import com.hivemq.persistence.payload.PublishPayloadPersistence;
import com.hivemq.util.Checkpoints;
import java.util.List;
import javax.inject.Inject;

public class HiveMQInstance {
    @NotNull
    private final HiveMQNettyBootstrap nettyBootstrap;
    @NotNull
    private final PublishPayloadPersistence payloadPersistence;
    @NotNull
    private final ExtensionBootstrap extensionBootstrap;
    @NotNull
    private final AdminService adminService;

    @Inject
    HiveMQInstance(@NotNull HiveMQNettyBootstrap nettyBootstrap, @NotNull PublishPayloadPersistence payloadPersistence, @NotNull ExtensionBootstrap extensionBootstrap, @NotNull AdminService adminService) {
        this.nettyBootstrap = nettyBootstrap;
        this.payloadPersistence = payloadPersistence;
        this.extensionBootstrap = extensionBootstrap;
        this.adminService = adminService;
    }

    public void start(@Nullable EmbeddedExtension embeddedExtension) throws Exception {
        this.payloadPersistence.init();
        this.extensionBootstrap.startExtensionSystem(embeddedExtension).get();
        List startupInformation = (List)this.nettyBootstrap.bootstrapServer().get();
        Checkpoints.checkpoint("listener-started");
        new StartupListenerVerifier(startupInformation).verifyAndPrint();
        ((AdminServiceImpl)this.adminService).hivemqStarted();
    }
}

