/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.bootstrap;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.hivemq.bootstrap.BindInformation;
import com.hivemq.bootstrap.ListenerStartupInformation;
import com.hivemq.bootstrap.NettyShutdownHook;
import com.hivemq.bootstrap.netty.ChannelInitializerFactory;
import com.hivemq.bootstrap.netty.NettyConfiguration;
import com.hivemq.common.shutdown.ShutdownHooks;
import com.hivemq.configuration.service.entity.ClientWriteBufferProperties;
import com.hivemq.configuration.service.entity.Listener;
import com.hivemq.configuration.service.entity.TcpListener;
import com.hivemq.configuration.service.entity.TlsTcpListener;
import com.hivemq.configuration.service.entity.TlsWebsocketListener;
import com.hivemq.configuration.service.entity.WebsocketListener;
import com.hivemq.configuration.service.impl.listener.ListenerConfigurationService;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.persistence.connection.ConnectionPersistence;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveMQNettyBootstrap {
    private static final Logger log = LoggerFactory.getLogger(HiveMQNettyBootstrap.class);
    @NotNull
    private final ShutdownHooks shutdownHooks;
    @NotNull
    private final ListenerConfigurationService listenerConfigurationService;
    @NotNull
    private final ChannelInitializerFactory channelInitializerFactory;
    @NotNull
    private final ConnectionPersistence connectionPersistence;
    @NotNull
    private final NettyConfiguration nettyConfiguration;
    public static final ClientWriteBufferProperties DEFAULT_WRITE_BUFFER_PROPERTIES = new ClientWriteBufferProperties(65536, 32768);

    @Inject
    HiveMQNettyBootstrap(@NotNull ShutdownHooks shutdownHooks, @NotNull ListenerConfigurationService listenerConfigurationService, @NotNull ChannelInitializerFactory channelInitializerFactory, @NotNull ConnectionPersistence connectionPersistence, @NotNull NettyConfiguration nettyConfiguration) {
        this.shutdownHooks = shutdownHooks;
        this.listenerConfigurationService = listenerConfigurationService;
        this.channelInitializerFactory = channelInitializerFactory;
        this.connectionPersistence = connectionPersistence;
        this.nettyConfiguration = nettyConfiguration;
    }

    @NotNull
    public ListenableFuture<List<ListenerStartupInformation>> bootstrapServer() {
        int shutdownTimeout = 60;
        int channelsShutdownTimeout = 180;
        this.shutdownHooks.add(new NettyShutdownHook(this.nettyConfiguration.getChildEventLoopGroup(), this.nettyConfiguration.getParentEventLoopGroup(), 60, 180, this.connectionPersistence));
        ArrayList<BindInformation> futures = new ArrayList<BindInformation>();
        this.addDefaultListeners();
        futures.addAll(this.bindTcpListeners(this.listenerConfigurationService.getTcpListeners()));
        futures.addAll(this.tlsTcpListeners(this.listenerConfigurationService.getTlsTcpListeners()));
        futures.addAll(this.websocketListeners(this.listenerConfigurationService.getWebsocketListeners()));
        futures.addAll(this.tlsWebsocketListeners(this.listenerConfigurationService.getTlsWebsocketListeners()));
        return this.aggregatedFuture(futures);
    }

    private void addDefaultListeners() {
        if (this.listenerConfigurationService.getListeners().isEmpty()) {
            this.listenerConfigurationService.addListener(new TcpListener(1883, "0.0.0.0"));
        }
    }

    @NotNull
    private List<BindInformation> bindTcpListeners(@NotNull List<TcpListener> tcpListeners) {
        log.trace("Checking TCP listeners");
        ImmutableList.Builder futures = ImmutableList.builder();
        for (TcpListener listener : tcpListeners) {
            ServerBootstrap b = this.createServerBootstrap(this.nettyConfiguration.getParentEventLoopGroup(), this.nettyConfiguration.getChildEventLoopGroup(), listener);
            log.info("Starting TCP listener on address {} and port {}", (Object)listener.getBindAddress(), (Object)listener.getPort());
            ChannelFuture bind = b.bind(listener.getBindAddress(), listener.getPort());
            this.connectionPersistence.addServerChannel(listener.getName(), bind.channel());
            futures.add((Object)new BindInformation(listener, bind));
        }
        return futures.build();
    }

    @NotNull
    private List<BindInformation> tlsTcpListeners(@NotNull List<TlsTcpListener> tlsTcpListeners) {
        log.trace("Checking TLS TCP listeners");
        ImmutableList.Builder futures = ImmutableList.builder();
        for (TlsTcpListener listener : tlsTcpListeners) {
            ServerBootstrap b = this.createServerBootstrap(this.nettyConfiguration.getParentEventLoopGroup(), this.nettyConfiguration.getChildEventLoopGroup(), listener);
            log.info("Starting TLS TCP listener on address {} and port {}", (Object)listener.getBindAddress(), (Object)listener.getPort());
            ChannelFuture bind = b.bind(listener.getBindAddress(), listener.getPort());
            this.connectionPersistence.addServerChannel(listener.getName(), bind.channel());
            futures.add((Object)new BindInformation(listener, bind));
        }
        return futures.build();
    }

    @NotNull
    private List<BindInformation> websocketListeners(@NotNull List<WebsocketListener> websocketListeners) {
        log.trace("Checking Websocket listeners");
        ImmutableList.Builder futures = ImmutableList.builder();
        for (WebsocketListener listener : websocketListeners) {
            ServerBootstrap b = this.createServerBootstrap(this.nettyConfiguration.getParentEventLoopGroup(), this.nettyConfiguration.getChildEventLoopGroup(), listener);
            log.info("Starting Websocket listener on address {} and port {}", (Object)listener.getBindAddress(), (Object)listener.getPort());
            ChannelFuture bind = b.bind(listener.getBindAddress(), listener.getPort());
            this.connectionPersistence.addServerChannel(listener.getName(), bind.channel());
            futures.add((Object)new BindInformation(listener, bind));
        }
        return futures.build();
    }

    @NotNull
    private List<BindInformation> tlsWebsocketListeners(@NotNull List<TlsWebsocketListener> tlsWebsocketListeners) {
        log.trace("Checking Websocket TLS listeners");
        ImmutableList.Builder futures = ImmutableList.builder();
        for (TlsWebsocketListener listener : tlsWebsocketListeners) {
            ServerBootstrap b = this.createServerBootstrap(this.nettyConfiguration.getParentEventLoopGroup(), this.nettyConfiguration.getChildEventLoopGroup(), listener);
            log.info("Starting Websocket TLS listener on address {} and port {}", (Object)listener.getBindAddress(), (Object)listener.getPort());
            ChannelFuture bind = b.bind(listener.getBindAddress(), listener.getPort());
            this.connectionPersistence.addServerChannel(listener.getName(), bind.channel());
            futures.add((Object)new BindInformation(listener, bind));
        }
        return futures.build();
    }

    @NotNull
    private ListenableFuture<List<ListenerStartupInformation>> aggregatedFuture(@NotNull List<BindInformation> bindInformation) {
        List listenableFutures = bindInformation.stream().map(input -> {
            SettableFuture objectSettableFuture = SettableFuture.create();
            input.getBindFuture().addListener((GenericFutureListener)new UpdateGivenFutureListener((BindInformation)input, (SettableFuture<ListenerStartupInformation>)objectSettableFuture));
            return objectSettableFuture;
        }).collect(Collectors.toList());
        return Futures.allAsList(listenableFutures);
    }

    @NotNull
    private ServerBootstrap createServerBootstrap(@NotNull EventLoopGroup bossGroup, @NotNull EventLoopGroup workerGroup, @NotNull Listener listener) {
        ServerBootstrap b = ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group(bossGroup, workerGroup).channel(this.nettyConfiguration.getServerSocketChannelClass())).childHandler((ChannelHandler)this.channelInitializerFactory.getChannelInitializer(listener)).option(ChannelOption.SO_BACKLOG, (Object)128)).option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT)).childOption(ChannelOption.SO_KEEPALIVE, (Object)true).childOption(ChannelOption.TCP_NODELAY, (Object)true).childOption(ChannelOption.SO_REUSEADDR, (Object)true).childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT);
        this.setAdvancedOptions(b);
        return b;
    }

    private void setAdvancedOptions(@NotNull ServerBootstrap b) {
        int sendBufferSize = -1;
        int receiveBufferSize = -1;
        int writeBufferHigh = 65536;
        int writeBufferLow = 32768;
        ClientWriteBufferProperties properties = HiveMQNettyBootstrap.validateWriteBufferProperties(new ClientWriteBufferProperties(65536, 32768));
        b.childOption(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)new WriteBufferWaterMark(properties.getLowThresholdBytes(), properties.getHighThresholdBytes()));
    }

    @VisibleForTesting
    @NotNull
    public static ClientWriteBufferProperties validateWriteBufferProperties(@NotNull ClientWriteBufferProperties writeBufferProperties) {
        Preconditions.checkNotNull((Object)writeBufferProperties, (Object)"writeBufferProperties must not be null");
        if (HiveMQNettyBootstrap.validateWriteBufferThresholds(writeBufferProperties.getHighThresholdBytes(), writeBufferProperties.getLowThresholdBytes())) {
            return writeBufferProperties;
        }
        return DEFAULT_WRITE_BUFFER_PROPERTIES;
    }

    private static boolean validateWriteBufferThresholds(int high, int low) {
        if (low <= 0) {
            log.warn("write-buffer low-threshold must be greater than zero");
            return false;
        }
        if (high < low) {
            log.warn("write-buffer high-threshold must be greater than write-buffer low-threshold");
            return false;
        }
        return true;
    }

    private static class UpdateGivenFutureListener
    implements ChannelFutureListener {
        @NotNull
        private final BindInformation bindInformation;
        @NotNull
        private final SettableFuture<ListenerStartupInformation> settableFuture;

        UpdateGivenFutureListener(@NotNull BindInformation bindInformation, @NotNull SettableFuture<ListenerStartupInformation> settableFuture) {
            this.bindInformation = bindInformation;
            this.settableFuture = settableFuture;
        }

        public void operationComplete(@NotNull ChannelFuture future) {
            Listener listener = this.bindInformation.getListener();
            if (future.isSuccess()) {
                int bindPort = ((InetSocketAddress)future.channel().localAddress()).getPort();
                listener.setPort(bindPort);
                this.settableFuture.set((Object)ListenerStartupInformation.successfulListenerStartup(listener));
            } else {
                this.settableFuture.set((Object)ListenerStartupInformation.failedListenerStartup(listener, future.cause()));
            }
        }
    }
}

