/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.bootstrap.netty.initializer;

import com.google.common.base.Preconditions;
import com.hivemq.bootstrap.ClientConnectionContext;
import com.hivemq.bootstrap.UndefinedClientConnection;
import com.hivemq.bootstrap.netty.ChannelDependencies;
import com.hivemq.bootstrap.netty.initializer.ChannelGroupHandler;
import com.hivemq.codec.decoder.MQTTMessageDecoder;
import com.hivemq.configuration.service.RestrictionsConfigurationService;
import com.hivemq.configuration.service.entity.Listener;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.logging.LoggingUtils;
import com.hivemq.mqtt.handler.connect.MessageBarrier;
import com.hivemq.mqtt.handler.publish.PublishFlushHandler;
import com.hivemq.security.exception.SslException;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.handler.timeout.IdleStateHandler;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractChannelInitializer
extends ChannelInitializer<Channel> {
    @NotNull
    private static final Logger log = LoggerFactory.getLogger(AbstractChannelInitializer.class);
    @NotNull
    private final ChannelDependencies channelDependencies;
    @NotNull
    private final Listener listener;
    private final boolean throttlingEnabled;
    private final boolean legacyNettyShutdown;

    protected AbstractChannelInitializer(@NotNull ChannelDependencies channelDependencies, @NotNull Listener listener) {
        this.channelDependencies = channelDependencies;
        this.listener = listener;
        boolean incomingEnabled = channelDependencies.getRestrictionsConfigurationService().incomingLimit() > 0L;
        boolean outgoingEnabled = false;
        this.legacyNettyShutdown = false;
        this.throttlingEnabled = incomingEnabled;
    }

    protected void initChannel(@NotNull Channel ch) throws Exception {
        Preconditions.checkNotNull((Object)ch, (Object)"Channel must never be null");
        if (!this.legacyNettyShutdown && this.channelDependencies.getShutdownHooks().isShuttingDown()) {
            ch.config().setAutoRead(false);
            ch.close();
            return;
        }
        PublishFlushHandler publishFlushHandler = this.channelDependencies.createPublishFlushHandler();
        UndefinedClientConnection clientContext = new UndefinedClientConnection(ch, publishFlushHandler, this.listener);
        ch.attr(ClientConnectionContext.CHANNEL_ATTRIBUTE_NAME).set((Object)clientContext);
        ch.pipeline().addLast("all_channel_group_handler", (ChannelHandler)new ChannelGroupHandler(this.channelDependencies.getChannelGroup()));
        if (this.throttlingEnabled) {
            ch.pipeline().addLast("global_throttling_handler", (ChannelHandler)this.channelDependencies.getGlobalTrafficShapingHandler());
        }
        ch.pipeline().addLast("mqtt_message_decoder", (ChannelHandler)new MQTTMessageDecoder(this.channelDependencies));
        ch.pipeline().addLast("mqtt_message_encoder", (ChannelHandler)this.channelDependencies.getMqttMessageEncoder());
        this.addNoConnectIdleHandler(ch);
        ch.pipeline().addLast("mqtt_message_barrier", (ChannelHandler)new MessageBarrier(this.channelDependencies.getMqttServerDisconnector()));
        ch.pipeline().addLast("plugin_initializer_handler", (ChannelHandler)this.channelDependencies.getPluginInitializerHandler());
        ch.pipeline().addLast("interceptor_handler", (ChannelHandler)this.channelDependencies.getInterceptorHandler());
        ch.pipeline().addLast("message_expiry_handler", (ChannelHandler)this.channelDependencies.getPublishMessageExpiryHandler());
        ch.pipeline().addLast("mqtt_subscribe_handler", (ChannelHandler)this.channelDependencies.getSubscribeHandler());
        ch.pipeline().addLast("mqtt_publish_flush", (ChannelHandler)publishFlushHandler);
        ch.pipeline().addLast("client_lifecycle_event_handler", (ChannelHandler)this.channelDependencies.getClientLifecycleEventHandler());
        ch.pipeline().addLast("mqtt_auth_handler", (ChannelHandler)this.channelDependencies.getAuthHandler());
        ch.pipeline().addLast("connection_limiter", (ChannelHandler)this.channelDependencies.getConnectionLimiterHandler());
        ch.pipeline().addLast("mqtt_connect_handler", (ChannelHandler)this.channelDependencies.getConnectHandler());
        ch.pipeline().addLast("mqtt_pingreq_handler", (ChannelHandler)this.channelDependencies.getPingRequestHandler());
        ch.pipeline().addLast("mqtt_unsubscribe_handler", (ChannelHandler)this.channelDependencies.getUnsubscribeHandler());
        ch.pipeline().addLast("mqtt_disconnect_handler", (ChannelHandler)this.channelDependencies.getDisconnectHandler());
        this.addSpecialHandlers(ch);
        ch.pipeline().addLast("exception_handler", (ChannelHandler)this.channelDependencies.getExceptionHandler());
    }

    protected void addNoConnectIdleHandler(@NotNull Channel ch) {
        RestrictionsConfigurationService restrictionsConfig = this.channelDependencies.getRestrictionsConfigurationService();
        long timeoutMillis = restrictionsConfig.noConnectIdleTimeout();
        if (timeoutMillis > 0L) {
            IdleStateHandler idleStateHandler = new IdleStateHandler(timeoutMillis, 0L, 0L, TimeUnit.MILLISECONDS);
            ch.pipeline().addAfter("mqtt_message_encoder", "new_connection_idle_handler", (ChannelHandler)idleStateHandler);
            ch.pipeline().addAfter("new_connection_idle_handler", "no_connect_idle_event_handler", (ChannelHandler)this.channelDependencies.getNoConnectIdleHandler());
        }
    }

    protected abstract void addSpecialHandlers(@NotNull Channel var1) throws Exception;

    public void exceptionCaught(@NotNull ChannelHandlerContext ctx, @NotNull Throwable cause) throws Exception {
        if (cause instanceof SslException) {
            ClientConnectionContext clientConnectionContext = ClientConnectionContext.of(ctx.channel());
            log.error("{}. Disconnecting client {} ", (Object)cause.getMessage(), (Object)clientConnectionContext.getChannelIP().orElse("UNKNOWN"));
            log.debug("Original exception:", cause);
            String eventLogMessage = LoggingUtils.appendListenerToMessage(ctx.channel(), cause.getMessage());
            this.channelDependencies.getMqttServerDisconnector().logAndClose(ctx.channel(), null, eventLogMessage);
        } else {
            super.exceptionCaught(ctx, cause);
        }
    }
}

