/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.codec.decoder.mqtt3;

import com.hivemq.bootstrap.ClientConnectionContext;
import com.hivemq.bootstrap.ioc.lazysingleton.LazySingleton;
import com.hivemq.codec.decoder.AbstractMqttConnectDecoder;
import com.hivemq.configuration.HivemqId;
import com.hivemq.configuration.service.FullConfigurationService;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.mqtt.handler.connack.MqttConnacker;
import com.hivemq.mqtt.message.ProtocolVersion;
import com.hivemq.mqtt.message.connect.CONNECT;
import com.hivemq.mqtt.message.connect.MqttWillPublish;
import com.hivemq.mqtt.message.reason.Mqtt5ConnAckReasonCode;
import com.hivemq.util.Bytes;
import com.hivemq.util.ClientIds;
import com.hivemq.util.Strings;
import io.netty.buffer.ByteBuf;

@LazySingleton
public class Mqtt311ConnectDecoder
extends AbstractMqttConnectDecoder {
    public static final String PROTOCOL_NAME = "MQTT";
    @NotNull
    private final HivemqId hiveMQId;

    public Mqtt311ConnectDecoder(@NotNull MqttConnacker connacker, @NotNull ClientIds clientIds, @NotNull FullConfigurationService configurationService, @NotNull HivemqId hiveMQId) {
        super(connacker, configurationService, clientIds);
        this.hiveMQId = hiveMQId;
    }

    @Override
    @Nullable
    public CONNECT decode(@NotNull ClientConnectionContext clientConnectionContext, @NotNull ByteBuf buf, byte header) {
        byte[] password;
        String userName;
        MqttWillPublish willPublish;
        String clientId;
        int utf8StringLength;
        int keepAlive;
        int willQoS;
        boolean isUsernameFlag;
        boolean isPasswordFlag;
        boolean isWillRetain;
        boolean isWillFlag;
        boolean isCleanSessionFlag;
        block27: {
            block26: {
                if (!this.validateHeader(header)) {
                    this.disconnectByInvalidFixedHeader(clientConnectionContext);
                    return null;
                }
                ByteBuf connectHeader = this.decodeFixedVariableHeaderConnect(clientConnectionContext, buf);
                if (connectHeader == null) {
                    return null;
                }
                if (!this.validateProtocolName(connectHeader, clientConnectionContext, PROTOCOL_NAME)) {
                    return null;
                }
                connectHeader.readByte();
                byte connectFlagsByte = connectHeader.readByte();
                if (!this.validateConnectFlagByte(connectFlagsByte, clientConnectionContext)) {
                    return null;
                }
                isCleanSessionFlag = Bytes.isBitSet(connectFlagsByte, 1);
                isWillFlag = Bytes.isBitSet(connectFlagsByte, 2);
                isWillRetain = Bytes.isBitSet(connectFlagsByte, 5);
                isPasswordFlag = Bytes.isBitSet(connectFlagsByte, 6);
                isUsernameFlag = Bytes.isBitSet(connectFlagsByte, 7);
                willQoS = (connectFlagsByte & 0x18) >> 3;
                if (!this.validateWill(isWillFlag, isWillRetain, willQoS, clientConnectionContext)) {
                    return null;
                }
                if (!this.validateUsernamePassword(isUsernameFlag, isPasswordFlag)) {
                    this.mqttConnacker.connackError(clientConnectionContext.getChannel(), "A client (IP: {}) connected with an invalid username/password combination. The password flag was set but the username flag was not set. Disconnecting client.", "Sent a CONNECT with invalid username/password combination", Mqtt5ConnAckReasonCode.PROTOCOL_ERROR, "Sent CONNECT with invalid username/password combination.");
                    return null;
                }
                keepAlive = connectHeader.readUnsignedShort();
                if (buf.readableBytes() < 2) break block26;
                utf8StringLength = buf.readUnsignedShort();
                if (buf.readableBytes() >= utf8StringLength || utf8StringLength <= 0) break block27;
            }
            this.mqttConnacker.connackError(clientConnectionContext.getChannel(), "A client (IP: {}) sent a CONNECT message with an incorrect client id length. Disconnecting client.", "Sent CONNECT with incorrect client id length", Mqtt5ConnAckReasonCode.MALFORMED_PACKET, "Sent CONNECT with invalid client identifier.");
            return null;
        }
        if (this.validateUTF8 && utf8StringLength > 0) {
            clientId = Strings.getValidatedPrefixedString(buf, utf8StringLength, true);
            if (clientId == null) {
                this.mqttConnacker.connackError(clientConnectionContext.getChannel(), "The client id of the client (IP: {}) is not well formed. This is not allowed. Disconnecting client.", "Sent CONNECT with malformed client id", Mqtt5ConnAckReasonCode.MALFORMED_PACKET, "Sent CONNECT with invalid client identifier.");
                return null;
            }
        } else if (utf8StringLength == 0) {
            if (!isCleanSessionFlag) {
                this.mqttConnacker.connackError(clientConnectionContext.getChannel(), "A client (IP: {}) connected with a persistent session and NO clientID. Using an empty client ID is only allowed when using a cleanSession. Disconnecting client.", "Sent CONNECT with a persistent session and NO clientID", Mqtt5ConnAckReasonCode.CLIENT_IDENTIFIER_NOT_VALID, "Sent CONNECT with invalid client identifier.");
                return null;
            }
            if (!this.allowAssignedClientId) {
                this.mqttConnacker.connackError(clientConnectionContext.getChannel(), "The client id of the client (IP: {}) is empty. This is not allowed. Disconnecting client.", "Sent CONNECT with empty client id", Mqtt5ConnAckReasonCode.CLIENT_IDENTIFIER_NOT_VALID, "Sent CONNECT with invalid client identifier.");
                return null;
            }
            clientId = this.clientIds.generateNext();
            clientConnectionContext.setClientIdAssigned(true);
        } else {
            clientId = Strings.getPrefixedString(buf, utf8StringLength);
        }
        clientConnectionContext.setClientId(clientId);
        if (isWillFlag) {
            willPublish = this.readMqtt3WillPublish(clientConnectionContext, buf, willQoS, isWillRetain, this.hiveMQId);
            if (willPublish == null) {
                return null;
            }
        } else {
            willPublish = null;
        }
        if (isUsernameFlag) {
            userName = Strings.getPrefixedString(buf);
            if (userName == null) {
                this.mqttConnacker.connackError(clientConnectionContext.getChannel(), "A client (IP: {}) sent a CONNECT with an incorrect username length. Disconnecting client.", "Sent a CONNECT with an incorrect username length", Mqtt5ConnAckReasonCode.MALFORMED_PACKET, "Sent CONNECT with malformed username.");
                return null;
            }
            clientConnectionContext.setAuthUsername(userName);
        } else {
            userName = null;
        }
        if (isPasswordFlag) {
            password = Bytes.getPrefixedBytes(buf);
            if (password == null) {
                this.mqttConnacker.connackError(clientConnectionContext.getChannel(), "A client (IP: {}) sent a CONNECT with an incorrect password length. Disconnecting client.", "Sent a CONNECT with an incorrect password length", Mqtt5ConnAckReasonCode.MALFORMED_PACKET, "Sent CONNECT with malformed password.");
                return null;
            }
            clientConnectionContext.setAuthPassword(password);
        } else {
            password = null;
        }
        clientConnectionContext.setConnectKeepAlive(keepAlive);
        clientConnectionContext.setCleanStart(isCleanSessionFlag);
        long sessionExpiryInterval = isCleanSessionFlag ? 0L : this.maxSessionExpiryInterval;
        clientConnectionContext.setClientSessionExpiryInterval(sessionExpiryInterval);
        return new CONNECT.Mqtt3Builder().withProtocolVersion(ProtocolVersion.MQTTv3_1_1).withClientIdentifier(clientId).withUsername(userName).withPassword(password).withCleanStart(isCleanSessionFlag).withSessionExpiryInterval(sessionExpiryInterval).withKeepAlive(keepAlive).withWillPublish(willPublish).build();
    }
}

