/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.codec.encoder.mqtt3;

import com.hivemq.bootstrap.ClientConnectionContext;
import com.hivemq.codec.encoder.MqttEncoder;
import com.hivemq.codec.encoder.mqtt5.MqttMessageEncoderUtil;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.mqtt.message.Message;
import io.netty.buffer.ByteBuf;

public abstract class AbstractVariableHeaderLengthEncoder<T extends Message>
implements MqttEncoder<T> {
    protected static void createRemainingLength(int messageLength, @NotNull ByteBuf buffer) {
        int val = messageLength;
        do {
            byte b = (byte)(val % 128);
            if ((val /= 128) > 0) {
                b = (byte)(b | 0xFFFFFF80);
            }
            buffer.writeByte((int)b);
        } while (val > 0);
    }

    @Override
    public int bufferSize(@NotNull ClientConnectionContext clientConnectionContext, @NotNull T msg) {
        int remainingLength = this.remainingLength(msg);
        int encodedLengthWithHeader = MqttMessageEncoderUtil.encodedPacketLength(remainingLength);
        msg.setRemainingLength(remainingLength);
        msg.setEncodedLength(encodedLengthWithHeader);
        return encodedLengthWithHeader;
    }

    protected abstract int remainingLength(@NotNull T var1);
}

