/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.codec.encoder.mqtt3;

import com.google.common.collect.ImmutableList;
import com.hivemq.bootstrap.ClientConnectionContext;
import com.hivemq.codec.encoder.mqtt3.AbstractVariableHeaderLengthEncoder;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.mqtt.handler.disconnect.MqttServerDisconnector;
import com.hivemq.mqtt.message.ProtocolVersion;
import com.hivemq.mqtt.message.mqtt5.Mqtt5UserProperties;
import com.hivemq.mqtt.message.reason.Mqtt5DisconnectReasonCode;
import com.hivemq.mqtt.message.reason.Mqtt5SubAckReasonCode;
import com.hivemq.mqtt.message.suback.SUBACK;
import io.netty.buffer.ByteBuf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Mqtt3SubackEncoder
extends AbstractVariableHeaderLengthEncoder<SUBACK> {
    private static final Logger log = LoggerFactory.getLogger(Mqtt3SubackEncoder.class);
    public static final int VARIABLE_HEADER_SIZE = 2;
    private static final byte SUBACK_FIXED_HEADER = -112;
    @NotNull
    private final MqttServerDisconnector mqttServerDisconnector;

    public Mqtt3SubackEncoder(@NotNull MqttServerDisconnector mqttServerDisconnector) {
        this.mqttServerDisconnector = mqttServerDisconnector;
    }

    @Override
    public void encode(@NotNull ClientConnectionContext clientConnectionContext, @NotNull SUBACK msg, @NotNull ByteBuf out) {
        if (this.closedIfNotAllowed(clientConnectionContext, msg)) {
            return;
        }
        out.writeByte(-112);
        int remainingLength = msg.getRemainingLength();
        Mqtt3SubackEncoder.createRemainingLength(remainingLength, out);
        out.writeShort(msg.getPacketIdentifier());
        for (Mqtt5SubAckReasonCode granted : msg.getReasonCodes()) {
            if (granted.getCode() >= 128) {
                out.writeByte(Mqtt5SubAckReasonCode.UNSPECIFIED_ERROR.getCode());
                continue;
            }
            out.writeByte(granted.getCode());
        }
    }

    private boolean closedIfNotAllowed(@NotNull ClientConnectionContext clientConnectionContext, @NotNull SUBACK msg) {
        ProtocolVersion protocolVersion = clientConnectionContext.getProtocolVersion();
        ImmutableList grantedQos = msg.getReasonCodes();
        if (grantedQos.isEmpty()) {
            log.error("Tried to write a SUBACK with empty payload to a client. Disconnecting client (IP: {}).", (Object)clientConnectionContext.getChannelIP().orElse("UNKNOWN"));
            this.mqttServerDisconnector.disconnect(clientConnectionContext.getChannel(), null, "Tried to write a SUBACK with empty payload to a client.", Mqtt5DisconnectReasonCode.IMPLEMENTATION_SPECIFIC_ERROR, null, Mqtt5UserProperties.NO_USER_PROPERTIES, false, true);
            return true;
        }
        for (Mqtt5SubAckReasonCode granted : grantedQos) {
            if (granted.getCode() >= 128 && protocolVersion == ProtocolVersion.MQTTv3_1) {
                log.error("Tried to write a failure code (0x80) to a MQTT 3.1 subscriber. Disconnecting client (IP: {}).", (Object)clientConnectionContext.getChannelIP().orElse("UNKNOWN"));
                this.mqttServerDisconnector.disconnect(clientConnectionContext.getChannel(), null, "Tried to write a failure code (0x80) to a MQTT 3.1 subscriber.", Mqtt5DisconnectReasonCode.IMPLEMENTATION_SPECIFIC_ERROR, null, Mqtt5UserProperties.NO_USER_PROPERTIES, false, true);
                return true;
            }
            if (granted == Mqtt5SubAckReasonCode.GRANTED_QOS_0 || granted == Mqtt5SubAckReasonCode.GRANTED_QOS_1 || granted == Mqtt5SubAckReasonCode.GRANTED_QOS_2 || granted.getCode() >= 128) continue;
            log.error("Tried to write an invalid SUBACK return code to a subscriber. Disconnecting client (IP: {}).", (Object)clientConnectionContext.getChannelIP().orElse("UNKNOWN"));
            this.mqttServerDisconnector.disconnect(clientConnectionContext.getChannel(), null, "Tried to write an invalid SUBACK return code to a subscriber.", Mqtt5DisconnectReasonCode.IMPLEMENTATION_SPECIFIC_ERROR, null, Mqtt5UserProperties.NO_USER_PROPERTIES, false, true);
            return true;
        }
        return false;
    }

    @Override
    protected int remainingLength(@NotNull SUBACK msg) {
        return msg.getReasonCodes().size() + 2;
    }
}

