/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.codec.encoder.mqtt5;

import com.google.common.base.Preconditions;
import com.hivemq.codec.encoder.mqtt5.Mqtt5MessageEncoderUtil;
import com.hivemq.codec.encoder.mqtt5.Mqtt5MessageWithUserPropertiesEncoder;
import com.hivemq.codec.encoder.mqtt5.MqttVariableByteInteger;
import com.hivemq.configuration.service.SecurityConfigurationService;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.mqtt.message.MessageType;
import com.hivemq.mqtt.message.connack.CONNACK;
import com.hivemq.mqtt.message.dropping.MessageDroppedService;
import com.hivemq.mqtt.message.reason.Mqtt5ConnAckReasonCode;
import io.netty.buffer.ByteBuf;

public class Mqtt5ConnackEncoder
extends Mqtt5MessageWithUserPropertiesEncoder.Mqtt5MessageWithReasonStringEncoder<CONNACK> {
    private static final int CONNACK_FIXED_HEADER = MessageType.CONNACK.ordinal() << 4;

    public Mqtt5ConnackEncoder(@NotNull MessageDroppedService messageDroppedService, @NotNull SecurityConfigurationService securityConfigurationService) {
        super(messageDroppedService, securityConfigurationService);
    }

    @Override
    void encode(@NotNull CONNACK connack, @NotNull ByteBuf out) {
        Preconditions.checkNotNull((Object)connack, (Object)"Connack must not be null.");
        Preconditions.checkNotNull((Object)out, (Object)"ByteBuf must not be null.");
        Mqtt5ConnackEncoder.encodeFixedHeader(out, connack.getRemainingLength());
        this.encodeVariableHeader(connack, out);
    }

    @Override
    int calculateRemainingLengthWithoutProperties(@NotNull CONNACK connack) {
        Preconditions.checkNotNull((Object)connack, (Object)"Connack must not be null.");
        return 2;
    }

    @Override
    int calculatePropertyLength(@NotNull CONNACK connack) {
        Preconditions.checkNotNull((Object)connack, (Object)"Connack must not be null.");
        int propertyLength = 0;
        propertyLength += Mqtt5ConnackEncoder.fixedPropertyLength(connack);
        propertyLength += Mqtt5MessageEncoderUtil.nullablePropertyEncodedLength(connack.getReasonString());
        return propertyLength += connack.getUserProperties().encodedLength();
    }

    private static int fixedPropertyLength(@NotNull CONNACK connack) {
        Preconditions.checkNotNull((Object)connack, (Object)"Connack must not be null.");
        int propertyLength = 0;
        propertyLength += Mqtt5MessageEncoderUtil.intPropertyEncodedLength(connack.getSessionExpiryInterval(), Long.MAX_VALUE);
        propertyLength += Mqtt5MessageEncoderUtil.shortPropertyEncodedLength(connack.getReceiveMaximum(), 65535);
        propertyLength += Mqtt5MessageEncoderUtil.nullablePropertyEncodedLength(connack.getMaximumQoS());
        propertyLength += Mqtt5MessageEncoderUtil.booleanPropertyEncodedLength(connack.isRetainAvailable(), true);
        propertyLength += Mqtt5MessageEncoderUtil.intPropertyEncodedLength(connack.getMaximumPacketSize(), 0x10000004L);
        propertyLength += Mqtt5MessageEncoderUtil.nullablePropertyEncodedLength(connack.getAssignedClientIdentifier());
        propertyLength += Mqtt5MessageEncoderUtil.shortPropertyEncodedLength(connack.getTopicAliasMaximum(), 0);
        propertyLength += Mqtt5MessageEncoderUtil.booleanPropertyEncodedLength(connack.isWildcardSubscriptionAvailable(), true);
        propertyLength += Mqtt5MessageEncoderUtil.booleanPropertyEncodedLength(connack.isSubscriptionIdentifierAvailable(), true);
        propertyLength += Mqtt5MessageEncoderUtil.booleanPropertyEncodedLength(connack.isSharedSubscriptionAvailable(), true);
        propertyLength += Mqtt5MessageEncoderUtil.shortPropertyEncodedLength(connack.getServerKeepAlive(), -1);
        propertyLength += Mqtt5MessageEncoderUtil.nullablePropertyEncodedLength(connack.getResponseInformation());
        propertyLength += Mqtt5MessageEncoderUtil.nullablePropertyEncodedLength(connack.getServerReference());
        propertyLength += Mqtt5MessageEncoderUtil.nullablePropertyEncodedLength(connack.getAuthMethod());
        return propertyLength += Mqtt5MessageEncoderUtil.nullablePropertyEncodedLength(connack.getAuthData());
    }

    private static void encodeFixedHeader(@NotNull ByteBuf out, int remainingLength) {
        Preconditions.checkNotNull((Object)out, (Object)"ByteBuf must not be null.");
        out.writeByte(CONNACK_FIXED_HEADER);
        MqttVariableByteInteger.encode(remainingLength, out);
    }

    private void encodeVariableHeader(@NotNull CONNACK connack, @NotNull ByteBuf out) {
        Preconditions.checkNotNull((Object)connack, (Object)"Connack must not be null.");
        Preconditions.checkNotNull((Object)out, (Object)"ByteBuf must not be null.");
        out.writeByte(connack.isSessionPresent() ? 1 : 0);
        Mqtt5ConnAckReasonCode reasonCode = (Mqtt5ConnAckReasonCode)connack.getReasonCode();
        out.writeByte(reasonCode.getCode());
        this.encodeProperties(connack, out);
    }

    private void encodeProperties(@NotNull CONNACK connack, @NotNull ByteBuf out) {
        Preconditions.checkNotNull((Object)connack, (Object)"Connack must not be null.");
        Preconditions.checkNotNull((Object)out, (Object)"ByteBuf must not be null.");
        MqttVariableByteInteger.encode(connack.getPropertyLength(), out);
        Mqtt5ConnackEncoder.encodeFixedProperties(connack, out);
        this.encodeOmissibleProperties(connack, out);
    }

    private static void encodeFixedProperties(@NotNull CONNACK connack, @NotNull ByteBuf out) {
        Preconditions.checkNotNull((Object)connack, (Object)"Connack must not be null.");
        Preconditions.checkNotNull((Object)out, (Object)"ByteBuf must not be null.");
        Mqtt5MessageEncoderUtil.encodeIntProperty(17, connack.getSessionExpiryInterval(), Long.MAX_VALUE, out);
        Mqtt5MessageEncoderUtil.encodeShortProperty(33, connack.getReceiveMaximum(), 65535, out);
        Mqtt5MessageEncoderUtil.encodeNullableProperty(36, connack.getMaximumQoS(), out);
        Mqtt5MessageEncoderUtil.encodeBooleanProperty(37, connack.isRetainAvailable(), true, out);
        Mqtt5MessageEncoderUtil.encodeIntProperty(39, connack.getMaximumPacketSize(), 0x10000004L, out);
        Mqtt5MessageEncoderUtil.encodeNullableProperty(18, connack.getAssignedClientIdentifier(), out);
        Mqtt5MessageEncoderUtil.encodeShortProperty(34, connack.getTopicAliasMaximum(), 0, out);
        Mqtt5MessageEncoderUtil.encodeBooleanProperty(40, connack.isWildcardSubscriptionAvailable(), true, out);
        Mqtt5MessageEncoderUtil.encodeBooleanProperty(41, connack.isSubscriptionIdentifierAvailable(), true, out);
        Mqtt5MessageEncoderUtil.encodeBooleanProperty(42, connack.isSharedSubscriptionAvailable(), true, out);
        Mqtt5MessageEncoderUtil.encodeShortProperty(19, connack.getServerKeepAlive(), -1, out);
        Mqtt5MessageEncoderUtil.encodeNullableProperty(26, connack.getResponseInformation(), out);
        Mqtt5MessageEncoderUtil.encodeNullableProperty(28, connack.getServerReference(), out);
        Mqtt5MessageEncoderUtil.encodeNullableProperty(21, connack.getAuthMethod(), out);
        Mqtt5MessageEncoderUtil.encodeNullableProperty(22, connack.getAuthData(), out);
    }
}

