/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.configuration.service.impl;

import com.hivemq.configuration.service.RestrictionsConfigurationService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class RestrictionsConfigurationServiceImpl
implements RestrictionsConfigurationService {
    private static final Logger log = LoggerFactory.getLogger(RestrictionsConfigurationServiceImpl.class);
    private final AtomicLong maxConnections = new AtomicLong(-1L);
    private final AtomicInteger maxClientIdLength = new AtomicInteger(65535);
    private final AtomicLong noConnectIdleTimeout = new AtomicLong(10000L);
    private final AtomicLong incomingLimit = new AtomicLong(0L);
    private final AtomicInteger maxTopicLength = new AtomicInteger(65535);

    @Override
    public long maxConnections() {
        return this.maxConnections.get();
    }

    @Override
    public int maxClientIdLength() {
        return this.maxClientIdLength.get();
    }

    @Override
    public long noConnectIdleTimeout() {
        return this.noConnectIdleTimeout.get();
    }

    @Override
    public long incomingLimit() {
        return this.incomingLimit.get();
    }

    @Override
    public int maxTopicLength() {
        return this.maxTopicLength.get();
    }

    @Override
    public void setMaxConnections(long maxConnections) {
        log.debug("Setting global maximum allowed connections to {}", (Object)maxConnections);
        this.maxConnections.set(maxConnections);
    }

    @Override
    public void setMaxClientIdLength(int maxClientIdLength) {
        log.debug("Setting the maximum client id length to {}", (Object)maxClientIdLength);
        this.maxClientIdLength.set(maxClientIdLength);
    }

    @Override
    public void setNoConnectIdleTimeout(long noConnectIdleTimeout) {
        log.debug("Setting the timeout for disconnecting idle tcp connections before a connect message was received to {} milliseconds", (Object)noConnectIdleTimeout);
        this.noConnectIdleTimeout.set(noConnectIdleTimeout);
    }

    @Override
    public void setIncomingLimit(long incomingLimit) {
        log.debug("Throttling the global incoming traffic limit {} bytes/second", (Object)incomingLimit);
        this.incomingLimit.set(incomingLimit);
    }

    @Override
    public void setMaxTopicLength(int maxTopicLength) {
        log.debug("Setting the maximum topic length to {}", (Object)maxTopicLength);
        this.maxTopicLength.set(maxTopicLength);
    }
}

