/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.auth.parameter;

import com.google.common.base.Preconditions;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.auth.parameter.SubscriptionAuthorizerInput;
import com.hivemq.extension.sdk.api.client.parameter.ClientInformation;
import com.hivemq.extension.sdk.api.client.parameter.ConnectionInformation;
import com.hivemq.extension.sdk.api.packets.general.UserProperties;
import com.hivemq.extension.sdk.api.packets.subscribe.Subscription;
import com.hivemq.extensions.ExtensionInformationUtil;
import com.hivemq.extensions.executor.task.PluginTaskInput;
import com.hivemq.extensions.packets.subscribe.SubscriptionImpl;
import com.hivemq.mqtt.message.subscribe.Topic;
import io.netty.channel.Channel;
import java.util.Optional;
import java.util.function.Supplier;

public class SubscriptionAuthorizerInputImpl
implements SubscriptionAuthorizerInput,
PluginTaskInput,
Supplier<SubscriptionAuthorizerInputImpl> {
    @NotNull
    private final UserProperties userProperties;
    @NotNull
    private final Optional<Integer> subscriptionIdentifier;
    @NotNull
    private final Subscription subscription;
    @NotNull
    private final ConnectionInformation connectionInformation;
    @NotNull
    private final ClientInformation clientInformation;

    public SubscriptionAuthorizerInputImpl(@NotNull UserProperties userProperties, @NotNull Topic topic, @NotNull Channel channel, @NotNull String clientId) {
        Preconditions.checkNotNull((Object)userProperties, (Object)"userproperties must never be null");
        Preconditions.checkNotNull((Object)topic, (Object)"topic must never be null");
        Preconditions.checkNotNull((Object)channel, (Object)"channel must never be null");
        Preconditions.checkNotNull((Object)clientId, (Object)"clientId must never be null");
        this.userProperties = userProperties;
        this.subscriptionIdentifier = topic.getSubscriptionIdentifier() != null && topic.getSubscriptionIdentifier() > 0 ? Optional.of(topic.getSubscriptionIdentifier()) : Optional.empty();
        this.subscription = new SubscriptionImpl(topic);
        this.clientInformation = ExtensionInformationUtil.getAndSetClientInformation(channel, clientId);
        this.connectionInformation = ExtensionInformationUtil.getAndSetConnectionInformation(channel);
    }

    @NotNull
    public UserProperties getUserProperties() {
        return this.userProperties;
    }

    @NotNull
    public Optional<Integer> getSubscriptionIdentifier() {
        return this.subscriptionIdentifier;
    }

    @NotNull
    public Subscription getSubscription() {
        return this.subscription;
    }

    @NotNull
    public ConnectionInformation getConnectionInformation() {
        return this.connectionInformation;
    }

    @NotNull
    public ClientInformation getClientInformation() {
        return this.clientInformation;
    }

    @Override
    @NotNull
    public SubscriptionAuthorizerInputImpl get() {
        return this;
    }
}

