/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.events.client.parameters;

import com.google.common.base.Preconditions;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.extension.sdk.api.client.parameter.ClientInformation;
import com.hivemq.extension.sdk.api.client.parameter.ConnectionInformation;
import com.hivemq.extension.sdk.api.events.client.parameters.ClientInitiatedDisconnectInput;
import com.hivemq.extension.sdk.api.events.client.parameters.ConnectionLostInput;
import com.hivemq.extension.sdk.api.packets.general.DisconnectedReasonCode;
import com.hivemq.extension.sdk.api.packets.general.UserProperties;
import com.hivemq.extensions.ExtensionInformationUtil;
import com.hivemq.extensions.executor.task.PluginTaskInput;
import io.netty.channel.Channel;
import java.util.Optional;
import java.util.function.Supplier;

public class ClientInitiatedDisconnectInputImpl
implements ClientInitiatedDisconnectInput,
ConnectionLostInput,
PluginTaskInput,
Supplier<ClientInitiatedDisconnectInputImpl> {
    @Nullable
    private final DisconnectedReasonCode reasonCode;
    @Nullable
    private final String reasonString;
    @Nullable
    private final UserProperties userProperties;
    private final boolean graceful;
    @NotNull
    private final ClientInformation clientInformation;
    @NotNull
    private final ConnectionInformation connectionInformation;

    public ClientInitiatedDisconnectInputImpl(@NotNull String clientId, @NotNull Channel channel, @Nullable DisconnectedReasonCode reasonCode, @Nullable String reasonString, @Nullable UserProperties userProperties, boolean graceful) {
        Preconditions.checkNotNull((Object)clientId, (Object)"client id must never be null");
        Preconditions.checkNotNull((Object)channel, (Object)"channel must never be null");
        this.reasonCode = reasonCode;
        this.reasonString = reasonString;
        this.userProperties = userProperties;
        this.graceful = graceful;
        this.connectionInformation = ExtensionInformationUtil.getAndSetConnectionInformation(channel);
        this.clientInformation = ExtensionInformationUtil.getAndSetClientInformation(channel, clientId);
    }

    @NotNull
    public ConnectionInformation getConnectionInformation() {
        return this.connectionInformation;
    }

    @NotNull
    public ClientInformation getClientInformation() {
        return this.clientInformation;
    }

    @NotNull
    public Optional<DisconnectedReasonCode> getReasonCode() {
        return Optional.ofNullable(this.reasonCode);
    }

    @NotNull
    public Optional<String> getReasonString() {
        return Optional.ofNullable(this.reasonString);
    }

    @NotNull
    public Optional<UserProperties> getUserProperties() {
        return Optional.ofNullable(this.userProperties);
    }

    public boolean isGraceful() {
        return this.graceful;
    }

    @Override
    @NotNull
    public ClientInitiatedDisconnectInputImpl get() {
        return this;
    }
}

