/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.handler;

import com.hivemq.bootstrap.ClientConnection;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.client.parameter.ClientInformation;
import com.hivemq.extension.sdk.api.client.parameter.ConnectionInformation;
import com.hivemq.extension.sdk.api.interceptor.pingreq.PingReqInboundInterceptor;
import com.hivemq.extension.sdk.api.interceptor.pingreq.parameter.PingReqInboundInput;
import com.hivemq.extension.sdk.api.interceptor.pingreq.parameter.PingReqInboundOutput;
import com.hivemq.extension.sdk.api.interceptor.pingresp.PingRespOutboundInterceptor;
import com.hivemq.extension.sdk.api.interceptor.pingresp.parameter.PingRespOutboundInput;
import com.hivemq.extension.sdk.api.interceptor.pingresp.parameter.PingRespOutboundOutput;
import com.hivemq.extensions.ExtensionInformationUtil;
import com.hivemq.extensions.HiveMQExtension;
import com.hivemq.extensions.HiveMQExtensions;
import com.hivemq.extensions.client.ClientContextImpl;
import com.hivemq.extensions.executor.PluginOutPutAsyncer;
import com.hivemq.extensions.executor.PluginTaskExecutorService;
import com.hivemq.extensions.executor.task.PluginInOutTask;
import com.hivemq.extensions.executor.task.PluginInOutTaskContext;
import com.hivemq.extensions.interceptor.pingreq.parameter.PingReqInboundInputImpl;
import com.hivemq.extensions.interceptor.pingreq.parameter.PingReqInboundOutputImpl;
import com.hivemq.extensions.interceptor.pingresp.parameter.PingRespOutboundInputImpl;
import com.hivemq.extensions.interceptor.pingresp.parameter.PingRespOutboundOutputImpl;
import com.hivemq.mqtt.message.PINGREQ;
import com.hivemq.mqtt.message.PINGRESP;
import com.hivemq.util.Exceptions;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class PingInterceptorHandler {
    private static final Logger log = LoggerFactory.getLogger(PingInterceptorHandler.class);
    @NotNull
    private final PluginTaskExecutorService executorService;
    @NotNull
    private final PluginOutPutAsyncer asyncer;
    @NotNull
    private final HiveMQExtensions hiveMQExtensions;

    @Inject
    public PingInterceptorHandler(@NotNull PluginTaskExecutorService executorService, @NotNull PluginOutPutAsyncer asyncer, @NotNull HiveMQExtensions hiveMQExtensions) {
        this.executorService = executorService;
        this.asyncer = asyncer;
        this.hiveMQExtensions = hiveMQExtensions;
    }

    public void handleInboundPingReq(@NotNull ChannelHandlerContext ctx, @NotNull PINGREQ pingreq) {
        Channel channel = ctx.channel();
        ClientConnection clientConnection = ClientConnection.of(channel);
        String clientId = clientConnection.getClientId();
        if (clientId == null) {
            return;
        }
        ClientContextImpl clientContext = clientConnection.getExtensionClientContext();
        if (clientContext == null) {
            ctx.fireChannelRead((Object)pingreq);
            return;
        }
        List<PingReqInboundInterceptor> interceptors = clientContext.getPingReqInboundInterceptors();
        if (interceptors.isEmpty()) {
            ctx.fireChannelRead((Object)pingreq);
            return;
        }
        ClientInformation clientInfo = ExtensionInformationUtil.getAndSetClientInformation(channel, clientId);
        ConnectionInformation connectionInfo = ExtensionInformationUtil.getAndSetConnectionInformation(channel);
        PingReqInboundInputImpl input = new PingReqInboundInputImpl(clientInfo, connectionInfo);
        PingReqInboundOutputImpl output = new PingReqInboundOutputImpl(this.asyncer);
        PingReqInboundInterceptorContext context = new PingReqInboundInterceptorContext(clientId, interceptors.size(), ctx);
        for (PingReqInboundInterceptor interceptor : interceptors) {
            HiveMQExtension extension = this.hiveMQExtensions.getExtensionForClassloader(interceptor.getClass().getClassLoader());
            if (extension == null) {
                context.finishInterceptor();
                continue;
            }
            PingReqInboundInterceptorTask task = new PingReqInboundInterceptorTask(interceptor, extension.getId());
            this.executorService.handlePluginInOutTaskExecution(context, input, output, task);
        }
    }

    public void handleOutboundPingResp(@NotNull ChannelHandlerContext ctx, @NotNull PINGRESP pingresp, @NotNull ChannelPromise promise) {
        Channel channel = ctx.channel();
        ClientConnection clientConnection = ClientConnection.of(channel);
        String clientId = clientConnection.getClientId();
        if (clientId == null) {
            return;
        }
        ClientContextImpl clientContext = clientConnection.getExtensionClientContext();
        if (clientContext == null) {
            ctx.write((Object)pingresp, promise);
            return;
        }
        List<PingRespOutboundInterceptor> interceptors = clientContext.getPingRespOutboundInterceptors();
        if (interceptors.isEmpty()) {
            ctx.write((Object)pingresp, promise);
            return;
        }
        ClientInformation clientInfo = ExtensionInformationUtil.getAndSetClientInformation(channel, clientId);
        ConnectionInformation connectionInfo = ExtensionInformationUtil.getAndSetConnectionInformation(channel);
        PingRespOutboundInputImpl input = new PingRespOutboundInputImpl(clientInfo, connectionInfo);
        PingRespOutboundOutputImpl output = new PingRespOutboundOutputImpl(this.asyncer);
        PingRespOutboundInterceptorContext context = new PingRespOutboundInterceptorContext(clientId, interceptors.size(), ctx, promise);
        for (PingRespOutboundInterceptor interceptor : interceptors) {
            HiveMQExtension extension = this.hiveMQExtensions.getExtensionForClassloader(interceptor.getClass().getClassLoader());
            if (extension == null) {
                context.finishInterceptor();
                continue;
            }
            PingRespOutboundInterceptorTask task = new PingRespOutboundInterceptorTask(interceptor, extension.getId());
            this.executorService.handlePluginInOutTaskExecution(context, input, output, task);
        }
    }

    private static class PingRespOutboundInterceptorContext
    extends PluginInOutTaskContext<PingRespOutboundOutputImpl>
    implements Runnable {
        private final int interceptorCount;
        @NotNull
        private final AtomicInteger counter;
        @NotNull
        private final ChannelHandlerContext ctx;
        @NotNull
        private final ChannelPromise promise;

        PingRespOutboundInterceptorContext(@NotNull String identifier, int interceptorCount, @NotNull ChannelHandlerContext ctx, @NotNull ChannelPromise promise) {
            super(identifier);
            this.interceptorCount = interceptorCount;
            this.counter = new AtomicInteger(0);
            this.ctx = ctx;
            this.promise = promise;
        }

        @Override
        public void pluginPost(@NotNull PingRespOutboundOutputImpl pluginOutput) {
            this.finishInterceptor();
        }

        public void finishInterceptor() {
            if (this.counter.incrementAndGet() == this.interceptorCount) {
                this.ctx.executor().execute((Runnable)this);
            }
        }

        @Override
        public void run() {
            this.ctx.writeAndFlush((Object)PINGRESP.INSTANCE, this.promise);
        }
    }

    private static class PingReqInboundInterceptorContext
    extends PluginInOutTaskContext<PingReqInboundOutputImpl>
    implements Runnable {
        private final int interceptorCount;
        @NotNull
        private final AtomicInteger counter;
        @NotNull
        private final ChannelHandlerContext ctx;

        PingReqInboundInterceptorContext(@NotNull String identifier, int interceptorCount, @NotNull ChannelHandlerContext ctx) {
            super(identifier);
            this.interceptorCount = interceptorCount;
            this.counter = new AtomicInteger(0);
            this.ctx = ctx;
        }

        @Override
        public void pluginPost(@NotNull PingReqInboundOutputImpl pluginOutput) {
            this.finishInterceptor();
        }

        public void finishInterceptor() {
            if (this.counter.incrementAndGet() == this.interceptorCount) {
                this.ctx.executor().execute((Runnable)this);
            }
        }

        @Override
        public void run() {
            this.ctx.fireChannelRead((Object)PINGREQ.INSTANCE);
        }
    }

    private static class PingRespOutboundInterceptorTask
    implements PluginInOutTask<PingRespOutboundInputImpl, PingRespOutboundOutputImpl> {
        @NotNull
        private final PingRespOutboundInterceptor interceptor;
        @NotNull
        private final String extensionId;

        PingRespOutboundInterceptorTask(@NotNull PingRespOutboundInterceptor interceptor, @NotNull String extensionId) {
            this.interceptor = interceptor;
            this.extensionId = extensionId;
        }

        @Override
        @NotNull
        public PingRespOutboundOutputImpl apply(@NotNull PingRespOutboundInputImpl input, @NotNull PingRespOutboundOutputImpl output) {
            try {
                this.interceptor.onOutboundPingResp((PingRespOutboundInput)input, (PingRespOutboundOutput)output);
            }
            catch (Throwable e) {
                log.warn("Uncaught exception was thrown from extension with id \"{}\" on outbound PINGRESP interception. Extensions are responsible for their own exception handling.", (Object)this.extensionId, (Object)e);
                Exceptions.rethrowError(e);
            }
            return output;
        }

        @Override
        @NotNull
        public ClassLoader getPluginClassLoader() {
            return this.interceptor.getClass().getClassLoader();
        }
    }

    private static class PingReqInboundInterceptorTask
    implements PluginInOutTask<PingReqInboundInputImpl, PingReqInboundOutputImpl> {
        @NotNull
        private final PingReqInboundInterceptor interceptor;
        @NotNull
        private final String extensionId;

        PingReqInboundInterceptorTask(@NotNull PingReqInboundInterceptor interceptor, @NotNull String extensionId) {
            this.interceptor = interceptor;
            this.extensionId = extensionId;
        }

        @Override
        @NotNull
        public PingReqInboundOutputImpl apply(@NotNull PingReqInboundInputImpl input, @NotNull PingReqInboundOutputImpl output) {
            try {
                this.interceptor.onInboundPingReq((PingReqInboundInput)input, (PingReqInboundOutput)output);
            }
            catch (Throwable e) {
                log.warn("Uncaught exception was thrown from extension with id \"{}\" on inbound PINGREQ interception. Extensions are responsible for their own exception handling.", (Object)this.extensionId, (Object)e);
                Exceptions.rethrowError(e);
            }
            return output;
        }

        @Override
        @NotNull
        public ClassLoader getPluginClassLoader() {
            return this.interceptor.getClass().getClassLoader();
        }
    }
}

