/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.handler;

import com.hivemq.bootstrap.ClientConnection;
import com.hivemq.configuration.service.FullConfigurationService;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.client.parameter.ClientInformation;
import com.hivemq.extension.sdk.api.client.parameter.ConnectionInformation;
import com.hivemq.extension.sdk.api.interceptor.pubcomp.PubcompInboundInterceptor;
import com.hivemq.extension.sdk.api.interceptor.pubcomp.PubcompOutboundInterceptor;
import com.hivemq.extension.sdk.api.interceptor.pubcomp.parameter.PubcompInboundInput;
import com.hivemq.extension.sdk.api.interceptor.pubcomp.parameter.PubcompInboundOutput;
import com.hivemq.extension.sdk.api.interceptor.pubcomp.parameter.PubcompOutboundInput;
import com.hivemq.extension.sdk.api.interceptor.pubcomp.parameter.PubcompOutboundOutput;
import com.hivemq.extensions.ExtensionInformationUtil;
import com.hivemq.extensions.HiveMQExtension;
import com.hivemq.extensions.HiveMQExtensions;
import com.hivemq.extensions.client.ClientContextImpl;
import com.hivemq.extensions.executor.PluginOutPutAsyncer;
import com.hivemq.extensions.executor.PluginTaskExecutorService;
import com.hivemq.extensions.executor.task.PluginInOutTask;
import com.hivemq.extensions.executor.task.PluginInOutTaskContext;
import com.hivemq.extensions.handler.ExtensionParameterHolder;
import com.hivemq.extensions.interceptor.pubcomp.parameter.PubcompInboundInputImpl;
import com.hivemq.extensions.interceptor.pubcomp.parameter.PubcompInboundOutputImpl;
import com.hivemq.extensions.interceptor.pubcomp.parameter.PubcompOutboundInputImpl;
import com.hivemq.extensions.interceptor.pubcomp.parameter.PubcompOutboundOutputImpl;
import com.hivemq.extensions.packets.pubcomp.ModifiablePubcompPacketImpl;
import com.hivemq.extensions.packets.pubcomp.PubcompPacketImpl;
import com.hivemq.mqtt.message.pubcomp.PUBCOMP;
import com.hivemq.util.Exceptions;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class PubcompInterceptorHandler {
    private static final Logger log = LoggerFactory.getLogger(PubcompInterceptorHandler.class);
    @NotNull
    private final FullConfigurationService configurationService;
    @NotNull
    private final PluginOutPutAsyncer asyncer;
    @NotNull
    private final HiveMQExtensions hiveMQExtensions;
    @NotNull
    private final PluginTaskExecutorService executorService;

    @Inject
    public PubcompInterceptorHandler(@NotNull FullConfigurationService configurationService, @NotNull PluginOutPutAsyncer asyncer, @NotNull HiveMQExtensions hiveMQExtensions, @NotNull PluginTaskExecutorService executorService) {
        this.configurationService = configurationService;
        this.asyncer = asyncer;
        this.hiveMQExtensions = hiveMQExtensions;
        this.executorService = executorService;
    }

    public void handleInboundPubcomp(@NotNull ChannelHandlerContext ctx, @NotNull PUBCOMP pubcomp) {
        Channel channel = ctx.channel();
        ClientConnection clientConnection = ClientConnection.of(channel);
        String clientId = clientConnection.getClientId();
        if (clientId == null) {
            return;
        }
        ClientContextImpl clientContext = clientConnection.getExtensionClientContext();
        if (clientContext == null) {
            ctx.fireChannelRead((Object)pubcomp);
            return;
        }
        List<PubcompInboundInterceptor> interceptors = clientContext.getPubcompInboundInterceptors();
        if (interceptors.isEmpty()) {
            ctx.fireChannelRead((Object)pubcomp);
            return;
        }
        ClientInformation clientInfo = ExtensionInformationUtil.getAndSetClientInformation(channel, clientId);
        ConnectionInformation connectionInfo = ExtensionInformationUtil.getAndSetConnectionInformation(channel);
        PubcompPacketImpl packet = new PubcompPacketImpl(pubcomp);
        PubcompInboundInputImpl input = new PubcompInboundInputImpl(clientInfo, connectionInfo, packet);
        ExtensionParameterHolder<PubcompInboundInputImpl> inputHolder = new ExtensionParameterHolder<PubcompInboundInputImpl>(input);
        ModifiablePubcompPacketImpl modifiablePacket = new ModifiablePubcompPacketImpl(packet, this.configurationService);
        PubcompInboundOutputImpl output = new PubcompInboundOutputImpl(this.asyncer, modifiablePacket);
        ExtensionParameterHolder<PubcompInboundOutputImpl> outputHolder = new ExtensionParameterHolder<PubcompInboundOutputImpl>(output);
        PubcompInboundInterceptorContext context = new PubcompInboundInterceptorContext(clientId, interceptors.size(), ctx, inputHolder, outputHolder);
        for (PubcompInboundInterceptor interceptor : interceptors) {
            HiveMQExtension extension = this.hiveMQExtensions.getExtensionForClassloader(interceptor.getClass().getClassLoader());
            if (extension == null) {
                context.finishInterceptor();
                continue;
            }
            PubcompInboundInterceptorTask task = new PubcompInboundInterceptorTask(interceptor, extension.getId());
            this.executorService.handlePluginInOutTaskExecution(context, inputHolder, outputHolder, task);
        }
    }

    public void handleOutboundPubcomp(@NotNull ChannelHandlerContext ctx, @NotNull PUBCOMP pubcomp, @NotNull ChannelPromise promise) {
        Channel channel = ctx.channel();
        ClientConnection clientConnection = ClientConnection.of(channel);
        String clientId = clientConnection.getClientId();
        if (clientId == null) {
            return;
        }
        ClientContextImpl clientContext = clientConnection.getExtensionClientContext();
        if (clientContext == null) {
            ctx.write((Object)pubcomp, promise);
            return;
        }
        List<PubcompOutboundInterceptor> interceptors = clientContext.getPubcompOutboundInterceptors();
        if (interceptors.isEmpty()) {
            ctx.write((Object)pubcomp, promise);
            return;
        }
        ClientInformation clientInfo = ExtensionInformationUtil.getAndSetClientInformation(channel, clientId);
        ConnectionInformation connectionInfo = ExtensionInformationUtil.getAndSetConnectionInformation(channel);
        PubcompPacketImpl packet = new PubcompPacketImpl(pubcomp);
        PubcompOutboundInputImpl input = new PubcompOutboundInputImpl(clientInfo, connectionInfo, packet);
        ExtensionParameterHolder<PubcompOutboundInputImpl> inputHolder = new ExtensionParameterHolder<PubcompOutboundInputImpl>(input);
        ModifiablePubcompPacketImpl modifiablePacket = new ModifiablePubcompPacketImpl(packet, this.configurationService);
        PubcompOutboundOutputImpl output = new PubcompOutboundOutputImpl(this.asyncer, modifiablePacket);
        ExtensionParameterHolder<PubcompOutboundOutputImpl> outputHolder = new ExtensionParameterHolder<PubcompOutboundOutputImpl>(output);
        PubcompOutboundInterceptorContext context = new PubcompOutboundInterceptorContext(clientId, interceptors.size(), ctx, promise, inputHolder, outputHolder);
        for (PubcompOutboundInterceptor interceptor : interceptors) {
            HiveMQExtension extension = this.hiveMQExtensions.getExtensionForClassloader(interceptor.getClass().getClassLoader());
            if (extension == null) {
                context.finishInterceptor();
                continue;
            }
            PubcompOutboundInterceptorTask task = new PubcompOutboundInterceptorTask(interceptor, extension.getId());
            this.executorService.handlePluginInOutTaskExecution(context, inputHolder, outputHolder, task);
        }
    }

    private static class PubcompOutboundInterceptorTask
    implements PluginInOutTask<PubcompOutboundInputImpl, PubcompOutboundOutputImpl> {
        @NotNull
        private final PubcompOutboundInterceptor interceptor;
        @NotNull
        private final String extensionId;

        PubcompOutboundInterceptorTask(@NotNull PubcompOutboundInterceptor interceptor, @NotNull String extensionId) {
            this.interceptor = interceptor;
            this.extensionId = extensionId;
        }

        @Override
        @NotNull
        public PubcompOutboundOutputImpl apply(@NotNull PubcompOutboundInputImpl input, @NotNull PubcompOutboundOutputImpl output) {
            try {
                this.interceptor.onOutboundPubcomp((PubcompOutboundInput)input, (PubcompOutboundOutput)output);
            }
            catch (Throwable e) {
                log.warn("Uncaught exception was thrown from extension with id \"{}\" on outbound PUBCOMP interception. Extensions are responsible for their own exception handling.", (Object)this.extensionId, (Object)e);
                output.markAsFailed();
                Exceptions.rethrowError(e);
            }
            return output;
        }

        @Override
        @NotNull
        public ClassLoader getPluginClassLoader() {
            return this.interceptor.getClass().getClassLoader();
        }
    }

    private static class PubcompOutboundInterceptorContext
    extends PluginInOutTaskContext<PubcompOutboundOutputImpl>
    implements Runnable {
        private final int interceptorCount;
        @NotNull
        private final AtomicInteger counter;
        @NotNull
        private final ChannelHandlerContext ctx;
        @NotNull
        private final ChannelPromise promise;
        @NotNull
        private final ExtensionParameterHolder<PubcompOutboundInputImpl> inputHolder;
        @NotNull
        private final ExtensionParameterHolder<PubcompOutboundOutputImpl> outputHolder;

        PubcompOutboundInterceptorContext(@NotNull String clientId, int interceptorCount, @NotNull ChannelHandlerContext ctx, @NotNull ChannelPromise promise, @NotNull ExtensionParameterHolder<PubcompOutboundInputImpl> inputHolder, @NotNull ExtensionParameterHolder<PubcompOutboundOutputImpl> outputHolder) {
            super(clientId);
            this.interceptorCount = interceptorCount;
            this.counter = new AtomicInteger(0);
            this.ctx = ctx;
            this.promise = promise;
            this.inputHolder = inputHolder;
            this.outputHolder = outputHolder;
        }

        @Override
        public void pluginPost(@NotNull PubcompOutboundOutputImpl output) {
            if (output.isTimedOut()) {
                log.debug("Async timeout on inbound DISCONNECT interception. Discarding changes made by the interceptor.");
            } else if (output.isFailed()) {
                log.debug("Exception on inbound DISCONNECT interception. Discarding changes made by the interceptor.");
            } else if (output.getPubcompPacket().isModified()) {
                this.inputHolder.set(this.inputHolder.get().update(output));
            }
            if (!this.finishInterceptor()) {
                this.outputHolder.set(output.update(this.inputHolder.get()));
            }
        }

        public boolean finishInterceptor() {
            if (this.counter.incrementAndGet() == this.interceptorCount) {
                this.ctx.executor().execute((Runnable)this);
                return true;
            }
            return false;
        }

        @Override
        public void run() {
            this.ctx.writeAndFlush((Object)PUBCOMP.from(this.inputHolder.get().getPubcompPacket()), this.promise);
        }
    }

    private static class PubcompInboundInterceptorTask
    implements PluginInOutTask<PubcompInboundInputImpl, PubcompInboundOutputImpl> {
        @NotNull
        private final PubcompInboundInterceptor interceptor;
        @NotNull
        private final String extensionId;

        PubcompInboundInterceptorTask(@NotNull PubcompInboundInterceptor interceptor, @NotNull String extensionId) {
            this.interceptor = interceptor;
            this.extensionId = extensionId;
        }

        @Override
        @NotNull
        public PubcompInboundOutputImpl apply(@NotNull PubcompInboundInputImpl input, @NotNull PubcompInboundOutputImpl output) {
            try {
                this.interceptor.onInboundPubcomp((PubcompInboundInput)input, (PubcompInboundOutput)output);
            }
            catch (Throwable e) {
                log.warn("Uncaught exception was thrown from extension with id \"{}\" on inbound PUBCOMP interception. Extensions are responsible for their own exception handling.", (Object)this.extensionId, (Object)e);
                output.markAsFailed();
                Exceptions.rethrowError(e);
            }
            return output;
        }

        @Override
        @NotNull
        public ClassLoader getPluginClassLoader() {
            return this.interceptor.getClass().getClassLoader();
        }
    }

    private static class PubcompInboundInterceptorContext
    extends PluginInOutTaskContext<PubcompInboundOutputImpl>
    implements Runnable {
        private final int interceptorCount;
        @NotNull
        private final AtomicInteger counter;
        @NotNull
        private final ChannelHandlerContext ctx;
        @NotNull
        private final ExtensionParameterHolder<PubcompInboundInputImpl> inputHolder;
        @NotNull
        private final ExtensionParameterHolder<PubcompInboundOutputImpl> outputHolder;

        PubcompInboundInterceptorContext(@NotNull String clientId, int interceptorCount, @NotNull ChannelHandlerContext ctx, @NotNull ExtensionParameterHolder<PubcompInboundInputImpl> inputHolder, @NotNull ExtensionParameterHolder<PubcompInboundOutputImpl> outputHolder) {
            super(clientId);
            this.interceptorCount = interceptorCount;
            this.counter = new AtomicInteger(0);
            this.ctx = ctx;
            this.inputHolder = inputHolder;
            this.outputHolder = outputHolder;
        }

        @Override
        public void pluginPost(@NotNull PubcompInboundOutputImpl output) {
            if (output.isTimedOut()) {
                log.debug("Async timeout on inbound PUBCOMP interception. Discarding changes made by the interceptor.");
            } else if (output.isFailed()) {
                log.debug("Exception on inbound PUBCOMP interception. Discarding changes made by the interceptor.");
            } else if (output.getPubcompPacket().isModified()) {
                this.inputHolder.set(this.inputHolder.get().update(output));
            }
            if (!this.finishInterceptor()) {
                this.outputHolder.set(output.update(this.inputHolder.get()));
            }
        }

        public boolean finishInterceptor() {
            if (this.counter.incrementAndGet() == this.interceptorCount) {
                this.ctx.executor().execute((Runnable)this);
                return true;
            }
            return false;
        }

        @Override
        public void run() {
            this.ctx.fireChannelRead((Object)PUBCOMP.from(this.inputHolder.get().getPubcompPacket()));
        }
    }
}

