/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.handler;

import com.hivemq.bootstrap.ClientConnection;
import com.hivemq.configuration.service.FullConfigurationService;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.client.parameter.ClientInformation;
import com.hivemq.extension.sdk.api.client.parameter.ConnectionInformation;
import com.hivemq.extension.sdk.api.interceptor.pubrec.PubrecInboundInterceptor;
import com.hivemq.extension.sdk.api.interceptor.pubrec.PubrecOutboundInterceptor;
import com.hivemq.extension.sdk.api.interceptor.pubrec.parameter.PubrecInboundInput;
import com.hivemq.extension.sdk.api.interceptor.pubrec.parameter.PubrecInboundOutput;
import com.hivemq.extension.sdk.api.interceptor.pubrec.parameter.PubrecOutboundInput;
import com.hivemq.extension.sdk.api.interceptor.pubrec.parameter.PubrecOutboundOutput;
import com.hivemq.extensions.ExtensionInformationUtil;
import com.hivemq.extensions.HiveMQExtension;
import com.hivemq.extensions.HiveMQExtensions;
import com.hivemq.extensions.client.ClientContextImpl;
import com.hivemq.extensions.executor.PluginOutPutAsyncer;
import com.hivemq.extensions.executor.PluginTaskExecutorService;
import com.hivemq.extensions.executor.task.PluginInOutTask;
import com.hivemq.extensions.executor.task.PluginInOutTaskContext;
import com.hivemq.extensions.handler.ExtensionParameterHolder;
import com.hivemq.extensions.interceptor.pubrec.parameter.PubrecInboundInputImpl;
import com.hivemq.extensions.interceptor.pubrec.parameter.PubrecInboundOutputImpl;
import com.hivemq.extensions.interceptor.pubrec.parameter.PubrecOutboundInputImpl;
import com.hivemq.extensions.interceptor.pubrec.parameter.PubrecOutboundOutputImpl;
import com.hivemq.extensions.packets.pubrec.ModifiablePubrecPacketImpl;
import com.hivemq.extensions.packets.pubrec.PubrecPacketImpl;
import com.hivemq.mqtt.message.pubrec.PUBREC;
import com.hivemq.util.Exceptions;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class PubrecInterceptorHandler {
    private static final Logger log = LoggerFactory.getLogger(PubrecInterceptorHandler.class);
    @NotNull
    private final FullConfigurationService configurationService;
    @NotNull
    private final PluginOutPutAsyncer asyncer;
    @NotNull
    private final HiveMQExtensions hiveMQExtensions;
    @NotNull
    private final PluginTaskExecutorService executorService;

    @Inject
    public PubrecInterceptorHandler(@NotNull FullConfigurationService configurationService, @NotNull PluginOutPutAsyncer asyncer, @NotNull HiveMQExtensions hiveMQExtensions, @NotNull PluginTaskExecutorService executorService) {
        this.configurationService = configurationService;
        this.asyncer = asyncer;
        this.hiveMQExtensions = hiveMQExtensions;
        this.executorService = executorService;
    }

    public void handleInboundPubrec(@NotNull ChannelHandlerContext ctx, @NotNull PUBREC pubrec) {
        Channel channel = ctx.channel();
        ClientConnection clientConnection = ClientConnection.of(channel);
        String clientId = clientConnection.getClientId();
        if (clientId == null) {
            return;
        }
        ClientContextImpl clientContext = clientConnection.getExtensionClientContext();
        if (clientContext == null) {
            ctx.fireChannelRead((Object)pubrec);
            return;
        }
        List<PubrecInboundInterceptor> interceptors = clientContext.getPubrecInboundInterceptors();
        if (interceptors.isEmpty()) {
            ctx.fireChannelRead((Object)pubrec);
            return;
        }
        ClientInformation clientInfo = ExtensionInformationUtil.getAndSetClientInformation(channel, clientId);
        ConnectionInformation connectionInfo = ExtensionInformationUtil.getAndSetConnectionInformation(channel);
        PubrecPacketImpl packet = new PubrecPacketImpl(pubrec);
        PubrecInboundInputImpl input = new PubrecInboundInputImpl(clientInfo, connectionInfo, packet);
        ExtensionParameterHolder<PubrecInboundInputImpl> inputHolder = new ExtensionParameterHolder<PubrecInboundInputImpl>(input);
        ModifiablePubrecPacketImpl modifiablePacket = new ModifiablePubrecPacketImpl(packet, this.configurationService);
        PubrecInboundOutputImpl output = new PubrecInboundOutputImpl(this.asyncer, modifiablePacket);
        ExtensionParameterHolder<PubrecInboundOutputImpl> outputHolder = new ExtensionParameterHolder<PubrecInboundOutputImpl>(output);
        PubrecInboundInterceptorContext context = new PubrecInboundInterceptorContext(clientId, interceptors.size(), ctx, inputHolder, outputHolder);
        for (PubrecInboundInterceptor interceptor : interceptors) {
            HiveMQExtension extension = this.hiveMQExtensions.getExtensionForClassloader(interceptor.getClass().getClassLoader());
            if (extension == null) {
                context.finishInterceptor();
                continue;
            }
            PubrecInboundInterceptorTask task = new PubrecInboundInterceptorTask(interceptor, extension.getId());
            this.executorService.handlePluginInOutTaskExecution(context, inputHolder, outputHolder, task);
        }
    }

    public void handleOutboundPubrec(@NotNull ChannelHandlerContext ctx, @NotNull PUBREC pubrec, @NotNull ChannelPromise promise) {
        Channel channel = ctx.channel();
        ClientConnection clientConnection = ClientConnection.of(channel);
        String clientId = clientConnection.getClientId();
        if (clientId == null) {
            return;
        }
        ClientContextImpl clientContext = clientConnection.getExtensionClientContext();
        if (clientContext == null) {
            ctx.write((Object)pubrec, promise);
            return;
        }
        List<PubrecOutboundInterceptor> interceptors = clientContext.getPubrecOutboundInterceptors();
        if (interceptors.isEmpty()) {
            ctx.write((Object)pubrec, promise);
            return;
        }
        ClientInformation clientInfo = ExtensionInformationUtil.getAndSetClientInformation(channel, clientId);
        ConnectionInformation connectionInfo = ExtensionInformationUtil.getAndSetConnectionInformation(channel);
        PubrecPacketImpl packet = new PubrecPacketImpl(pubrec);
        PubrecOutboundInputImpl input = new PubrecOutboundInputImpl(clientInfo, connectionInfo, packet);
        ExtensionParameterHolder<PubrecOutboundInputImpl> inputHolder = new ExtensionParameterHolder<PubrecOutboundInputImpl>(input);
        ModifiablePubrecPacketImpl modifiablePacket = new ModifiablePubrecPacketImpl(packet, this.configurationService);
        PubrecOutboundOutputImpl output = new PubrecOutboundOutputImpl(this.asyncer, modifiablePacket);
        ExtensionParameterHolder<PubrecOutboundOutputImpl> outputHolder = new ExtensionParameterHolder<PubrecOutboundOutputImpl>(output);
        PubrecOutboundInterceptorContext context = new PubrecOutboundInterceptorContext(clientId, interceptors.size(), ctx, promise, inputHolder, outputHolder);
        for (PubrecOutboundInterceptor interceptor : interceptors) {
            HiveMQExtension extension = this.hiveMQExtensions.getExtensionForClassloader(interceptor.getClass().getClassLoader());
            if (extension == null) {
                context.finishInterceptor();
                continue;
            }
            PubrecOutboundInterceptorTask task = new PubrecOutboundInterceptorTask(interceptor, extension.getId());
            this.executorService.handlePluginInOutTaskExecution(context, inputHolder, outputHolder, task);
        }
    }

    private static class PubrecOutboundInterceptorTask
    implements PluginInOutTask<PubrecOutboundInputImpl, PubrecOutboundOutputImpl> {
        @NotNull
        private final PubrecOutboundInterceptor interceptor;
        @NotNull
        private final String extensionId;

        PubrecOutboundInterceptorTask(@NotNull PubrecOutboundInterceptor interceptor, @NotNull String extensionId) {
            this.interceptor = interceptor;
            this.extensionId = extensionId;
        }

        @Override
        @NotNull
        public PubrecOutboundOutputImpl apply(@NotNull PubrecOutboundInputImpl input, @NotNull PubrecOutboundOutputImpl output) {
            try {
                this.interceptor.onOutboundPubrec((PubrecOutboundInput)input, (PubrecOutboundOutput)output);
            }
            catch (Throwable e) {
                log.warn("Uncaught exception was thrown from extension with id \"{}\" on outbound PUBREC interception. Extensions are responsible for their own exception handling.", (Object)this.extensionId, (Object)e);
                output.markAsFailed();
                Exceptions.rethrowError(e);
            }
            return output;
        }

        @Override
        @NotNull
        public ClassLoader getPluginClassLoader() {
            return this.interceptor.getClass().getClassLoader();
        }
    }

    private static class PubrecOutboundInterceptorContext
    extends PluginInOutTaskContext<PubrecOutboundOutputImpl>
    implements Runnable {
        private final int interceptorCount;
        @NotNull
        private final AtomicInteger counter;
        @NotNull
        private final ChannelHandlerContext ctx;
        @NotNull
        private final ChannelPromise promise;
        @NotNull
        private final ExtensionParameterHolder<PubrecOutboundInputImpl> inputHolder;
        @NotNull
        private final ExtensionParameterHolder<PubrecOutboundOutputImpl> outputHolder;

        PubrecOutboundInterceptorContext(@NotNull String clientId, int interceptorCount, @NotNull ChannelHandlerContext ctx, @NotNull ChannelPromise promise, @NotNull ExtensionParameterHolder<PubrecOutboundInputImpl> inputHolder, @NotNull ExtensionParameterHolder<PubrecOutboundOutputImpl> outputHolder) {
            super(clientId);
            this.interceptorCount = interceptorCount;
            this.counter = new AtomicInteger(0);
            this.ctx = ctx;
            this.promise = promise;
            this.inputHolder = inputHolder;
            this.outputHolder = outputHolder;
        }

        @Override
        public void pluginPost(@NotNull PubrecOutboundOutputImpl output) {
            if (output.isTimedOut()) {
                log.debug("Async timeout on outbound PUBREC interception. Discarding changes made by the interceptor.");
            } else if (output.isFailed()) {
                log.debug("Exception on outbound PUBREC interception. Discarding changes made by the interceptor.");
            } else if (output.getPubrecPacket().isModified()) {
                this.inputHolder.set(this.inputHolder.get().update(output));
            }
            if (!this.finishInterceptor()) {
                this.outputHolder.set(output.update(this.inputHolder.get()));
            }
        }

        public boolean finishInterceptor() {
            if (this.counter.incrementAndGet() == this.interceptorCount) {
                this.ctx.executor().execute((Runnable)this);
                return true;
            }
            return false;
        }

        @Override
        public void run() {
            this.ctx.writeAndFlush((Object)PUBREC.from(this.inputHolder.get().getPubrecPacket()), this.promise);
        }
    }

    private static class PubrecInboundInterceptorTask
    implements PluginInOutTask<PubrecInboundInputImpl, PubrecInboundOutputImpl> {
        @NotNull
        private final PubrecInboundInterceptor interceptor;
        @NotNull
        private final String extensionId;

        PubrecInboundInterceptorTask(@NotNull PubrecInboundInterceptor interceptor, @NotNull String extensionId) {
            this.interceptor = interceptor;
            this.extensionId = extensionId;
        }

        @Override
        @NotNull
        public PubrecInboundOutputImpl apply(@NotNull PubrecInboundInputImpl input, @NotNull PubrecInboundOutputImpl output) {
            try {
                this.interceptor.onInboundPubrec((PubrecInboundInput)input, (PubrecInboundOutput)output);
            }
            catch (Throwable e) {
                log.warn("Uncaught exception was thrown from extension with id \"{}\" on inbound PUBREC interception. Extensions are responsible for their own exception handling.", (Object)this.extensionId, (Object)e);
                output.markAsFailed();
                Exceptions.rethrowError(e);
            }
            return output;
        }

        @Override
        @NotNull
        public ClassLoader getPluginClassLoader() {
            return this.interceptor.getClass().getClassLoader();
        }
    }

    private static class PubrecInboundInterceptorContext
    extends PluginInOutTaskContext<PubrecInboundOutputImpl>
    implements Runnable {
        private final int interceptorCount;
        @NotNull
        private final AtomicInteger counter;
        @NotNull
        private final ChannelHandlerContext ctx;
        @NotNull
        private final ExtensionParameterHolder<PubrecInboundInputImpl> inputHolder;
        @NotNull
        private final ExtensionParameterHolder<PubrecInboundOutputImpl> outputHolder;

        PubrecInboundInterceptorContext(@NotNull String clientId, int interceptorCount, @NotNull ChannelHandlerContext ctx, @NotNull ExtensionParameterHolder<PubrecInboundInputImpl> inputHolder, @NotNull ExtensionParameterHolder<PubrecInboundOutputImpl> outputHolder) {
            super(clientId);
            this.interceptorCount = interceptorCount;
            this.counter = new AtomicInteger(0);
            this.ctx = ctx;
            this.inputHolder = inputHolder;
            this.outputHolder = outputHolder;
        }

        @Override
        public void pluginPost(@NotNull PubrecInboundOutputImpl output) {
            if (output.isTimedOut()) {
                log.debug("Async timeout on inbound PUBREC interception. Discarding changes made by the interceptor.");
            } else if (output.isFailed()) {
                log.debug("Exception on inbound PUBREC interception. Discarding changes made by the interceptor.");
            } else if (output.getPubrecPacket().isModified()) {
                this.inputHolder.set(this.inputHolder.get().update(output));
            }
            if (!this.finishInterceptor()) {
                this.outputHolder.set(output.update(this.inputHolder.get()));
            }
        }

        public boolean finishInterceptor() {
            if (this.counter.incrementAndGet() == this.interceptorCount) {
                this.ctx.executor().execute((Runnable)this);
                return true;
            }
            return false;
        }

        @Override
        public void run() {
            this.ctx.fireChannelRead((Object)PUBREC.from(this.inputHolder.get().getPubrecPacket()));
        }
    }
}

