/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.iteration;

import com.hivemq.bootstrap.ioc.lazysingleton.LazySingleton;
import com.hivemq.common.shutdown.HiveMQShutdownHook;
import com.hivemq.common.shutdown.ShutdownHooks;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extensions.iteration.AsyncIterator;
import com.hivemq.extensions.iteration.AsyncLocalChunkIterator;
import com.hivemq.extensions.iteration.FetchCallback;
import com.hivemq.util.ThreadFactoryUtil;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.inject.Inject;

@LazySingleton
public class AsyncIteratorFactory {
    @NotNull
    private final ExecutorService executorService = Executors.newFixedThreadPool(4, ThreadFactoryUtil.create("async-iterator-executor-%d"));

    @Inject
    public AsyncIteratorFactory(@NotNull ShutdownHooks shutdownHooks) {
        shutdownHooks.add(new HiveMQShutdownHook(){

            @Override
            @NotNull
            public String name() {
                return "Async Iterator Executor Shutdown";
            }

            @Override
            @NotNull
            public HiveMQShutdownHook.Priority priority() {
                return HiveMQShutdownHook.Priority.MEDIUM;
            }

            @Override
            public void run() {
                AsyncIteratorFactory.this.executorService.shutdown();
            }
        });
    }

    @NotNull
    public <V> AsyncIterator<V> createIterator(@NotNull FetchCallback<V> fetchCallback, @NotNull AsyncIterator.ItemCallback<V> iterationCallback) {
        return new AsyncLocalChunkIterator<V>(fetchCallback, iterationCallback, this.executorService);
    }
}

