/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.packets.disconnect;

import com.google.common.base.Preconditions;
import com.hivemq.configuration.service.FullConfigurationService;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.extension.sdk.api.annotations.ThreadSafe;
import com.hivemq.extension.sdk.api.packets.disconnect.DisconnectReasonCode;
import com.hivemq.extension.sdk.api.packets.disconnect.ModifiableOutboundDisconnectPacket;
import com.hivemq.extensions.packets.disconnect.DisconnectPacketImpl;
import com.hivemq.extensions.packets.general.ModifiableUserPropertiesImpl;
import com.hivemq.extensions.services.builder.PluginBuilderUtil;
import com.hivemq.mqtt.message.reason.Mqtt5DisconnectReasonCode;
import java.util.Objects;
import java.util.Optional;

@ThreadSafe
public class ModifiableOutboundDisconnectPacketImpl
implements ModifiableOutboundDisconnectPacket {
    @NotNull
    private DisconnectReasonCode reasonCode;
    @Nullable
    private String reasonString;
    private final long sessionExpiryInterval;
    @Nullable
    private String serverReference;
    @NotNull
    private final ModifiableUserPropertiesImpl userProperties;
    @NotNull
    private final FullConfigurationService configurationService;
    private boolean modified = false;

    public ModifiableOutboundDisconnectPacketImpl(@NotNull DisconnectPacketImpl packet, @NotNull FullConfigurationService configurationService) {
        this.reasonCode = packet.reasonCode;
        this.reasonString = packet.reasonString;
        this.sessionExpiryInterval = packet.sessionExpiryInterval;
        this.serverReference = packet.serverReference;
        this.userProperties = new ModifiableUserPropertiesImpl(packet.userProperties.asInternalList(), configurationService.securityConfiguration().validateUTF8());
        this.configurationService = configurationService;
    }

    @NotNull
    public DisconnectReasonCode getReasonCode() {
        return this.reasonCode;
    }

    public void setReasonCode(@NotNull DisconnectReasonCode reasonCode) {
        Preconditions.checkNotNull((Object)reasonCode, (Object)"Reason code must never be null");
        Preconditions.checkArgument((reasonCode != DisconnectReasonCode.CLIENT_IDENTIFIER_NOT_VALID ? 1 : 0) != 0, (String)"Reason code %s must not be used for disconnect packets.", (Object)reasonCode);
        Preconditions.checkArgument((boolean)Mqtt5DisconnectReasonCode.from(reasonCode).canBeSentByServer(), (String)"Reason code %s must not be used for outbound disconnect packets from the server to a client.", (Object)reasonCode);
        if (this.reasonCode == reasonCode) {
            return;
        }
        this.reasonCode = reasonCode;
        this.modified = true;
    }

    @NotNull
    public Optional<String> getReasonString() {
        return Optional.ofNullable(this.reasonString);
    }

    public void setReasonString(@Nullable String reasonString) {
        PluginBuilderUtil.checkReasonString(reasonString, this.configurationService.securityConfiguration().validateUTF8());
        if (Objects.equals(this.reasonString, reasonString)) {
            return;
        }
        this.reasonString = reasonString;
        this.modified = true;
    }

    @NotNull
    public Optional<Long> getSessionExpiryInterval() {
        return this.sessionExpiryInterval == Long.MAX_VALUE ? Optional.empty() : Optional.of(this.sessionExpiryInterval);
    }

    @NotNull
    public Optional<String> getServerReference() {
        return Optional.ofNullable(this.serverReference);
    }

    public void setServerReference(@Nullable String serverReference) {
        PluginBuilderUtil.checkServerReference(serverReference, this.configurationService.securityConfiguration().validateUTF8());
        if (Objects.equals(this.serverReference, serverReference)) {
            return;
        }
        this.serverReference = serverReference;
        this.modified = true;
    }

    @NotNull
    public ModifiableUserPropertiesImpl getUserProperties() {
        return this.userProperties;
    }

    public boolean isModified() {
        return this.modified || this.userProperties.isModified();
    }

    @NotNull
    public DisconnectPacketImpl copy() {
        return new DisconnectPacketImpl(this.reasonCode, this.reasonString, this.sessionExpiryInterval, this.serverReference, this.userProperties.copy());
    }

    @NotNull
    public ModifiableOutboundDisconnectPacketImpl update(@NotNull DisconnectPacketImpl packet) {
        return new ModifiableOutboundDisconnectPacketImpl(packet, this.configurationService);
    }
}

