/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.packets.suback;

import com.google.common.collect.ImmutableList;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.extension.sdk.api.packets.suback.SubackPacket;
import com.hivemq.extension.sdk.api.packets.subscribe.SubackReasonCode;
import com.hivemq.extensions.packets.general.UserPropertiesImpl;
import com.hivemq.mqtt.message.suback.SUBACK;
import java.util.Objects;
import java.util.Optional;

public class SubackPacketImpl
implements SubackPacket {
    @NotNull
    final ImmutableList<SubackReasonCode> reasonCodes;
    @Nullable
    final String reasonString;
    final int packetIdentifier;
    @NotNull
    final UserPropertiesImpl userProperties;

    public SubackPacketImpl(@NotNull ImmutableList<SubackReasonCode> reasonCodes, @Nullable String reasonString, int packetIdentifier, @NotNull UserPropertiesImpl userProperties) {
        this.reasonCodes = reasonCodes;
        this.reasonString = reasonString;
        this.packetIdentifier = packetIdentifier;
        this.userProperties = userProperties;
    }

    public SubackPacketImpl(@NotNull SUBACK subAck) {
        ImmutableList.Builder builder = ImmutableList.builder();
        subAck.getReasonCodes().forEach(code -> builder.add((Object)code.toSubackReasonCode()));
        this.reasonCodes = builder.build();
        this.reasonString = subAck.getReasonString();
        this.packetIdentifier = subAck.getPacketIdentifier();
        this.userProperties = UserPropertiesImpl.of(subAck.getUserProperties().asList());
    }

    @NotNull
    public ImmutableList<SubackReasonCode> getReasonCodes() {
        return this.reasonCodes;
    }

    @NotNull
    public Optional<String> getReasonString() {
        return Optional.ofNullable(this.reasonString);
    }

    public int getPacketIdentifier() {
        return this.packetIdentifier;
    }

    @NotNull
    public UserPropertiesImpl getUserProperties() {
        return this.userProperties;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SubackPacketImpl)) {
            return false;
        }
        SubackPacketImpl that = (SubackPacketImpl)o;
        return this.reasonCodes.equals(that.reasonCodes) && Objects.equals(this.reasonString, that.reasonString) && this.packetIdentifier == that.packetIdentifier && this.userProperties.equals(that.userProperties);
    }

    public int hashCode() {
        return Objects.hash(this.reasonCodes, this.reasonString, this.packetIdentifier, this.userProperties);
    }
}

