/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.packets.subscribe;

import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.extension.sdk.api.packets.general.Qos;
import com.hivemq.extension.sdk.api.packets.subscribe.RetainHandling;
import com.hivemq.extension.sdk.api.packets.subscribe.Subscription;
import com.hivemq.mqtt.message.subscribe.Topic;
import java.util.Objects;

public class SubscriptionImpl
implements Subscription {
    @NotNull
    final String topicFilter;
    @NotNull
    final Qos qos;
    @NotNull
    final RetainHandling retainHandling;
    final boolean retainAsPublished;
    final boolean noLocal;

    public SubscriptionImpl(@NotNull String topicFilter, @NotNull Qos qos, @NotNull RetainHandling retainHandling, boolean retainAsPublished, boolean noLocal) {
        this.topicFilter = topicFilter;
        this.qos = qos;
        this.retainHandling = retainHandling;
        this.retainAsPublished = retainAsPublished;
        this.noLocal = noLocal;
    }

    public SubscriptionImpl(@NotNull Topic topic) {
        this(topic.getTopic(), topic.getQoS().toQos(), Objects.requireNonNull(RetainHandling.fromCode((int)topic.getRetainHandling().getCode())), topic.isRetainAsPublished(), topic.isNoLocal());
    }

    @NotNull
    public String getTopicFilter() {
        return this.topicFilter;
    }

    @NotNull
    public Qos getQos() {
        return this.qos;
    }

    @NotNull
    public RetainHandling getRetainHandling() {
        return this.retainHandling;
    }

    public boolean getRetainAsPublished() {
        return this.retainAsPublished;
    }

    public boolean getNoLocal() {
        return this.noLocal;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SubscriptionImpl)) {
            return false;
        }
        SubscriptionImpl that = (SubscriptionImpl)o;
        return this.topicFilter.equals(that.topicFilter) && this.qos == that.qos && this.retainHandling == that.retainHandling && this.retainAsPublished == that.retainAsPublished && this.noLocal == that.noLocal;
    }

    public int hashCode() {
        return Objects.hash(this.topicFilter, this.qos, this.retainHandling, this.retainAsPublished, this.noLocal);
    }
}

