/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.services;

import com.hivemq.bootstrap.ioc.lazysingleton.LazySingleton;
import com.hivemq.configuration.service.InternalConfigurations;
import com.hivemq.extension.sdk.api.services.exception.RateLimitExceededException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

@LazySingleton
public class PluginServiceRateLimitService {
    public static final RateLimitExceededException RATE_LIMIT_EXCEEDED_EXCEPTION = new RateLimitExceededException();
    private final AtomicInteger counter = new AtomicInteger(0);
    private final AtomicInteger reserveCounter = new AtomicInteger(0);
    private final AtomicLong startTime = new AtomicLong(0L);
    private final AtomicLong resetTime = new AtomicLong(0L);
    private final int rateLimit = InternalConfigurations.EXTENSION_SERVICE_CALL_RATE_LIMIT_PER_SEC.get();

    public boolean rateLimitExceeded() {
        boolean exceeded;
        long rateTimer;
        if (this.rateLimit <= 0) {
            return false;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - (rateTimer = this.startTime.get()) >= 1000L && this.startTime.compareAndSet(rateTimer, currentTime)) {
            this.counter.set(1);
            long resetTime = this.resetTime.get();
            if (currentTime - resetTime > 10000L && this.startTime.compareAndSet(resetTime, currentTime)) {
                this.reserveCounter.set(1);
            }
            return false;
        }
        boolean bl = exceeded = this.counter.incrementAndGet() > this.rateLimit;
        if (exceeded) {
            return this.reserveCounter.incrementAndGet() > this.rateLimit;
        }
        return false;
    }

    static {
        RATE_LIMIT_EXCEEDED_EXCEPTION.setStackTrace(new StackTraceElement[0]);
    }
}

