/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.services.publish;

import com.hivemq.codec.encoder.mqtt5.Mqtt5PayloadFormatIndicator;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.extension.sdk.api.packets.general.Qos;
import com.hivemq.extension.sdk.api.packets.publish.PayloadFormatIndicator;
import com.hivemq.extension.sdk.api.services.publish.RetainedPublish;
import com.hivemq.extensions.packets.general.UserPropertiesImpl;
import com.hivemq.extensions.services.publish.PublishImpl;
import com.hivemq.mqtt.message.QoS;
import com.hivemq.mqtt.message.mqtt5.Mqtt5UserProperties;
import com.hivemq.persistence.RetainedMessage;
import com.hivemq.persistence.payload.PublishPayloadPersistence;
import com.hivemq.util.Bytes;
import java.nio.ByteBuffer;
import java.util.Objects;

public class RetainedPublishImpl
extends PublishImpl
implements RetainedPublish {
    public RetainedPublishImpl(@NotNull Qos qos, @NotNull String topic, @Nullable PayloadFormatIndicator payloadFormatIndicator, @Nullable Long messageExpiryInterval, @Nullable String responseTopic, @Nullable ByteBuffer correlationData, @Nullable String contentType, @Nullable ByteBuffer payload, @NotNull UserPropertiesImpl userProperties) {
        super(qos, true, topic, payloadFormatIndicator, messageExpiryInterval, responseTopic, correlationData, contentType, payload, userProperties);
    }

    public RetainedPublishImpl(@NotNull String topic, @NotNull RetainedMessage retainedMessage) {
        this(retainedMessage.getQos().toQos(), topic, retainedMessage.getPayloadFormatIndicator() == null ? null : PayloadFormatIndicator.valueOf((String)retainedMessage.getPayloadFormatIndicator().name()), retainedMessage.getMessageExpiryInterval(), retainedMessage.getResponseTopic(), retainedMessage.getCorrelationData() == null ? null : ByteBuffer.wrap(retainedMessage.getCorrelationData()).asReadOnlyBuffer(), retainedMessage.getContentType(), retainedMessage.getMessage() == null ? null : ByteBuffer.wrap(retainedMessage.getMessage()).asReadOnlyBuffer(), UserPropertiesImpl.of(retainedMessage.getUserProperties().asList()));
    }

    @NotNull
    public static RetainedMessage convert(@NotNull RetainedPublishImpl retainedPublish) {
        byte[] payloadAsArray = Bytes.getBytesFromReadOnlyBuffer(retainedPublish.getPayload());
        byte[] correlationDataAsArray = Bytes.getBytesFromReadOnlyBuffer(retainedPublish.getCorrelationData());
        Mqtt5PayloadFormatIndicator payloadFormatIndicator = retainedPublish.getPayloadFormatIndicator().isPresent() ? Mqtt5PayloadFormatIndicator.from(retainedPublish.getPayloadFormatIndicator().get()) : null;
        return new RetainedMessage(payloadAsArray, Objects.requireNonNull(QoS.valueOf(retainedPublish.getQos().getQosNumber())), PublishPayloadPersistence.createId(), retainedPublish.getMessageExpiryInterval().orElse(Long.MAX_VALUE), Mqtt5UserProperties.of(retainedPublish.getUserProperties().asInternalList()), retainedPublish.getResponseTopic().orElse(null), retainedPublish.getContentType().orElse(null), correlationDataAsArray, payloadFormatIndicator, System.currentTimeMillis());
    }
}

